/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.IntegrationMessageHeaderAccessor;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.aggregator.SequenceNumberComparator;
import org.springframework.integration.store.MessageGroup;
import org.springframework.messaging.Message;

public class SequenceSizeReleaseStrategy
implements ReleaseStrategy {
    private static final Log logger = LogFactory.getLog(SequenceSizeReleaseStrategy.class);
    private final Comparator<Message<?>> comparator = new SequenceNumberComparator();
    private volatile boolean releasePartialSequences;

    public SequenceSizeReleaseStrategy() {
        this(false);
    }

    public SequenceSizeReleaseStrategy(boolean releasePartialSequences) {
        this.releasePartialSequences = releasePartialSequences;
    }

    public void setReleasePartialSequences(boolean releasePartialSequences) {
        this.releasePartialSequences = releasePartialSequences;
    }

    @Override
    public boolean canRelease(MessageGroup messageGroup) {
        boolean canRelease = false;
        Collection<Message<?>> messages = messageGroup.getMessages();
        if (this.releasePartialSequences && !messages.isEmpty()) {
            int lastReleasedMessageSequence;
            Message<?> minMessage;
            int nextSequenceNumber;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Considering partial release of group [" + messageGroup + "]"));
            }
            if ((nextSequenceNumber = new IntegrationMessageHeaderAccessor(minMessage = Collections.min(messages, this.comparator)).getSequenceNumber().intValue()) - (lastReleasedMessageSequence = messageGroup.getLastReleasedMessageSequenceNumber()) == 1) {
                canRelease = true;
            }
        } else {
            int size = messages.size();
            if (size == 0) {
                canRelease = true;
            } else {
                int sequenceSize = new IntegrationMessageHeaderAccessor(messageGroup.getOne()).getSequenceSize();
                if (sequenceSize == size) {
                    canRelease = true;
                }
            }
        }
        return canRelease;
    }
}

