/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.support.channel.HeaderChannelRegistry;
import org.springframework.messaging.MessageChannel;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class DefaultHeaderChannelRegistry
extends IntegrationObjectSupport
implements HeaderChannelRegistry,
SmartLifecycle,
Runnable {
    private static final int DEFAULT_REAPER_DELAY = 60000;
    private final Map<String, MessageChannelWrapper> channels = new ConcurrentHashMap<String, MessageChannelWrapper>();
    private static final AtomicLong id = new AtomicLong();
    private final String uuid = UUID.randomUUID().toString() + ":";
    private volatile long reaperDelay;
    private volatile ScheduledFuture<?> reaperScheduledFuture;
    private volatile boolean running;
    private volatile int phase;
    private volatile boolean autoStartup = false;
    private volatile boolean explicitlyStopped;

    public DefaultHeaderChannelRegistry() {
        this(60000L);
    }

    public DefaultHeaderChannelRegistry(long reaperDelay) {
        this.setReaperDelay(reaperDelay);
    }

    public final void setReaperDelay(long reaperDelay) {
        Assert.isTrue((reaperDelay > 0L ? 1 : 0) != 0, (String)"'reaperDelay' must be > 0");
        this.reaperDelay = reaperDelay;
    }

    public final long getReaperDelay() {
        return this.reaperDelay;
    }

    @Override
    public void setTaskScheduler(TaskScheduler taskScheduler) {
        super.setTaskScheduler(taskScheduler);
    }

    @Deprecated
    public int getPhase() {
        return this.phase;
    }

    @Deprecated
    public final void setPhase(int phase) {
        this.phase = phase;
    }

    @Deprecated
    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    @Deprecated
    public final void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public final int size() {
        return this.channels.size();
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        Assert.notNull((Object)this.getTaskScheduler(), (String)"a task scheduler is required");
    }

    public synchronized void start() {
        if (!this.running) {
            Assert.notNull((Object)this.getTaskScheduler(), (String)"a task scheduler is required");
            this.reaperScheduledFuture = this.getTaskScheduler().schedule((Runnable)this, new Date(System.currentTimeMillis() + this.reaperDelay));
            this.running = true;
        }
    }

    public synchronized void stop() {
        this.running = false;
        if (this.reaperScheduledFuture != null) {
            this.reaperScheduledFuture.cancel(true);
        }
        this.explicitlyStopped = true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public Object channelToChannelName(Object channel) {
        if (!this.running && !this.explicitlyStopped && this.getTaskScheduler() != null) {
            this.start();
        }
        if (channel != null && channel instanceof MessageChannel) {
            String name = this.uuid + id.incrementAndGet();
            this.channels.put(name, new MessageChannelWrapper((MessageChannel)channel));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registered " + channel + " as " + name));
            }
            return name;
        }
        return channel;
    }

    @Override
    public MessageChannel channelNameToChannel(String name) {
        if (name != null) {
            MessageChannelWrapper messageChannelWrapper = this.channels.get(name);
            if (this.logger.isDebugEnabled() && messageChannelWrapper != null) {
                this.logger.debug((Object)("Retrieved " + messageChannelWrapper.getChannel() + " with " + name));
            }
            return messageChannelWrapper == null ? null : messageChannelWrapper.getChannel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runReaper() {
        DefaultHeaderChannelRegistry defaultHeaderChannelRegistry = this;
        synchronized (defaultHeaderChannelRegistry) {
            this.reaperScheduledFuture.cancel(false);
            this.reaperScheduledFuture = null;
        }
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.reaperScheduledFuture = null;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Reaper started; channels size=" + this.channels.size()));
        }
        Iterator<Map.Entry<String, MessageChannelWrapper>> iterator = this.channels.entrySet().iterator();
        long threshold = System.currentTimeMillis() - this.reaperDelay;
        while (iterator.hasNext()) {
            Map.Entry<String, MessageChannelWrapper> entry = iterator.next();
            if (entry.getValue().getCreated() >= threshold) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Expiring " + entry.getKey() + " (" + entry.getValue().getChannel() + ")"));
            }
            iterator.remove();
        }
        DefaultHeaderChannelRegistry defaultHeaderChannelRegistry = this;
        synchronized (defaultHeaderChannelRegistry) {
            if (this.reaperScheduledFuture == null) {
                this.reaperScheduledFuture = this.getTaskScheduler().schedule((Runnable)this, new Date(System.currentTimeMillis() + this.reaperDelay));
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Reaper completed; channels size=" + this.channels.size()));
        }
    }

    private class MessageChannelWrapper {
        private final MessageChannel channel;
        private final long created;

        private MessageChannelWrapper(MessageChannel channel) {
            this.channel = channel;
            this.created = System.currentTimeMillis();
        }

        public final long getCreated() {
            return this.created;
        }

        public final MessageChannel getChannel() {
            return this.channel;
        }
    }
}

