/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;

public final class FixedSubscriberChannel
implements SubscribableChannel,
BeanNameAware,
NamedComponent {
    private final Log logger = LogFactory.getLog(FixedSubscriberChannel.class);
    private final MessageHandler handler;
    private volatile String beanName;

    public FixedSubscriberChannel() {
        throw new IllegalArgumentException("Cannot instantiate a " + this.getClass().getSimpleName() + " without a MessageHandler.");
    }

    public FixedSubscriberChannel(MessageHandler handler) {
        this.handler = handler;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public boolean send(Message<?> message) {
        return this.send(message, 0L);
    }

    public boolean send(Message<?> message, long timeout) {
        try {
            this.handler.handleMessage(message);
            return true;
        }
        catch (Exception e) {
            Throwable runtimeException;
            Throwable throwable = runtimeException = e instanceof RuntimeException ? (RuntimeException)e : new MessageDeliveryException(message, this.getComponentName() + " failed to deliver Message.", (Throwable)e);
            if (e instanceof MessagingException && ((MessagingException)((Object)e)).getFailedMessage() == null) {
                runtimeException = new MessagingException(message, (Throwable)e);
            }
            throw runtimeException;
        }
    }

    public boolean subscribe(MessageHandler handler) {
        if (handler != this.handler && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getComponentName() + ": cannot be subscribed to (it has a fixed single subscriber)."));
        }
        return false;
    }

    public boolean unsubscribe(MessageHandler handler) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getComponentName() + ": cannot be unsubscribed from (it has a fixed single subscriber)."));
        }
        return false;
    }

    @Override
    public String getComponentType() {
        return "Fixed Subscriber Channel";
    }

    @Override
    public String getComponentName() {
        if (this.beanName != null) {
            return this.beanName;
        }
        return "Unnamed fixed subscriber channel";
    }
}

