/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.integration.channel.AbstractPollableChannel;
import org.springframework.integration.channel.QueueChannelOperations;
import org.springframework.integration.core.MessageSelector;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class QueueChannel
extends AbstractPollableChannel
implements QueueChannelOperations {
    private final BlockingQueue<Message<?>> queue;

    public QueueChannel(BlockingQueue<Message<?>> queue) {
        Assert.notNull(queue, (String)"'queue' must not be null");
        this.queue = queue;
    }

    public QueueChannel(int capacity) {
        Assert.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"The capacity must be a positive integer. For a zero-capacity alternative, consider using a 'RendezvousChannel'.");
        this.queue = new LinkedBlockingQueue(capacity);
    }

    public QueueChannel() {
        this(new LinkedBlockingQueue());
    }

    @Override
    protected boolean doSend(Message<?> message, long timeout) {
        Assert.notNull(message, (String)"'message' must not be null");
        try {
            if (timeout > 0L) {
                return this.queue.offer(message, timeout, TimeUnit.MILLISECONDS);
            }
            if (timeout == 0L) {
                return this.queue.offer(message);
            }
            this.queue.put(message);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    protected Message<?> doReceive(long timeout) {
        try {
            if (timeout > 0L) {
                return this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            }
            if (timeout == 0L) {
                return (Message)this.queue.poll();
            }
            return this.queue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public List<Message<?>> clear() {
        ArrayList clearedMessages = new ArrayList();
        this.queue.drainTo(clearedMessages);
        return clearedMessages;
    }

    @Override
    public List<Message<?>> purge(MessageSelector selector) {
        Object[] array;
        if (selector == null) {
            return this.clear();
        }
        ArrayList purgedMessages = new ArrayList();
        for (Object o : array = this.queue.toArray()) {
            Message message = (Message)o;
            if (selector.accept(message) || !this.queue.remove(message)) continue;
            purgedMessages.add(message);
        }
        return purgedMessages;
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public int getRemainingCapacity() {
        return this.queue.remainingCapacity();
    }
}

