/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel.interceptor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.integration.channel.ChannelInterceptorAware;
import org.springframework.integration.channel.interceptor.VetoCapableInterceptor;
import org.springframework.integration.core.MessageSelector;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.util.Assert;

@ManagedResource
public class WireTap
extends ChannelInterceptorAdapter
implements Lifecycle,
VetoCapableInterceptor {
    private static final Log logger = LogFactory.getLog(WireTap.class);
    private final MessageChannel channel;
    private volatile long timeout = 0L;
    private final MessageSelector selector;
    private volatile boolean running = true;

    public WireTap(MessageChannel channel) {
        this(channel, null);
    }

    public WireTap(MessageChannel channel, MessageSelector selector) {
        Assert.notNull((Object)channel, (String)"channel must not be null");
        this.channel = channel;
        this.selector = selector;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @ManagedAttribute
    public boolean isRunning() {
        return this.running;
    }

    @ManagedOperation
    public void start() {
        this.running = true;
    }

    @ManagedOperation
    public void stop() {
        this.running = false;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (this.channel.equals(channel)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WireTap is refusing to intercept its own channel '" + this.channel + "'"));
            }
            return message;
        }
        if (this.running && (this.selector == null || this.selector.accept(message))) {
            boolean sent;
            boolean bl = sent = this.timeout >= 0L ? this.channel.send(message, this.timeout) : this.channel.send(message);
            if (!sent && logger.isWarnEnabled()) {
                logger.warn((Object)("failed to send message to WireTap channel '" + this.channel + "'"));
            }
        }
        return message;
    }

    @Override
    public boolean shouldIntercept(String beanName, ChannelInterceptorAware channel) {
        return !this.channel.equals(channel);
    }
}

