/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.integration.config.IntegrationConfigUtils;
import org.springframework.util.Assert;

final class ChannelInitializer
implements BeanFactoryAware,
InitializingBean {
    private Log logger = LogFactory.getLog(this.getClass());
    private volatile BeanFactory beanFactory;
    private volatile boolean autoCreate = true;

    ChannelInitializer() {
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.beanFactory, (String)"'beanFactory' must not be null");
        if (!this.autoCreate) {
            return;
        }
        AutoCreateCandidatesCollector channelCandidatesCollector = (AutoCreateCandidatesCollector)this.beanFactory.getBean("$autoCreateChannelCandidates", AutoCreateCandidatesCollector.class);
        Assert.notNull((Object)channelCandidatesCollector, (String)"Failed to locate '$autoCreateChannelCandidates");
        Collection<String> channelNames = channelCandidatesCollector.getChannelNames();
        if (channelNames != null) {
            for (String channelName : channelNames) {
                if (this.beanFactory.containsBean(channelName)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Auto-creating channel '" + channelName + "' as DirectChannel"));
                }
                IntegrationConfigUtils.autoCreateDirectChannel(channelName, (BeanDefinitionRegistry)this.beanFactory);
            }
        }
    }

    static class AutoCreateCandidatesCollector {
        private final Collection<String> channelNames;

        public AutoCreateCandidatesCollector(Collection<String> channelNames) {
            this.channelNames = channelNames;
        }

        public Collection<String> getChannelNames() {
            return this.channelNames;
        }
    }
}

