/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.integration.aggregator.MethodInvokingReleaseStrategy;
import org.springframework.integration.aggregator.SequenceSizeReleaseStrategy;
import org.springframework.integration.annotation.ReleaseStrategy;
import org.springframework.integration.config.annotation.MessagingAnnotationUtils;
import org.springframework.util.StringUtils;

public class ReleaseStrategyFactoryBean
implements FactoryBean<org.springframework.integration.aggregator.ReleaseStrategy> {
    private static final Log logger = LogFactory.getLog(ReleaseStrategyFactoryBean.class);
    private org.springframework.integration.aggregator.ReleaseStrategy delegate = new SequenceSizeReleaseStrategy();

    public ReleaseStrategyFactoryBean(Object target) {
        this(target, null);
    }

    public ReleaseStrategyFactoryBean(Object target, String methodName) {
        if (target instanceof org.springframework.integration.aggregator.ReleaseStrategy && !StringUtils.hasText((String)methodName)) {
            this.delegate = (org.springframework.integration.aggregator.ReleaseStrategy)target;
            return;
        }
        if (target != null) {
            if (StringUtils.hasText((String)methodName)) {
                this.delegate = new MethodInvokingReleaseStrategy(target, methodName);
            } else {
                Method method = MessagingAnnotationUtils.findAnnotatedMethod(target, ReleaseStrategy.class);
                if (method != null) {
                    this.delegate = new MethodInvokingReleaseStrategy(target, method);
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)("No annotated method found; falling back to SequenceSizeReleaseStrategy, target:" + target + ", methodName:" + methodName));
                }
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"No target supplied; falling back to SequenceSizeReleaseStrategy");
        }
    }

    public org.springframework.integration.aggregator.ReleaseStrategy getObject() throws Exception {
        return this.delegate;
    }

    public Class<?> getObjectType() {
        return org.springframework.integration.aggregator.ReleaseStrategy.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

