/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;
import org.springframework.integration.annotation.Poller;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.config.annotation.MessagingAnnotationUtils;
import org.springframework.integration.config.annotation.MethodAnnotationPostProcessor;
import org.springframework.integration.context.Orderable;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.AbstractPollingEndpoint;
import org.springframework.integration.endpoint.EventDrivenConsumer;
import org.springframework.integration.endpoint.PollingConsumer;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractMethodAnnotationPostProcessor<T extends Annotation>
implements MethodAnnotationPostProcessor<T> {
    private static final String INPUT_CHANNEL_ATTRIBUTE = "inputChannel";
    private static final String ADVICE_CHAIN_ATTRIBUTE = "adviceChain";
    protected final ConfigurableListableBeanFactory beanFactory;
    protected final ConversionService conversionService;
    protected final Environment environment;
    protected final DestinationResolver<MessageChannel> channelResolver;
    protected final Class<T> annotationType;

    public AbstractMethodAnnotationPostProcessor(ListableBeanFactory beanFactory, Environment environment) {
        Assert.notNull((Object)beanFactory, (String)"'beanFactory' must not be null");
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"'beanFactory' must be instanceOf ConfigurableListableBeanFactory");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        ConversionService conversionService = this.beanFactory.getConversionService();
        this.conversionService = conversionService != null ? conversionService : new DefaultConversionService();
        this.environment = environment;
        this.channelResolver = new BeanFactoryChannelResolver((BeanFactory)beanFactory);
        this.annotationType = GenericTypeResolver.resolveTypeArgument(this.getClass(), MethodAnnotationPostProcessor.class);
    }

    @Override
    public Object postProcess(Object bean, String beanName, Method method, List<Annotation> annotations) {
        AbstractEndpoint endpoint;
        Order orderAnnotation;
        MessageHandler handler = this.createHandler(bean, method, annotations);
        this.setAdviceChainIfPresent(beanName, annotations, handler);
        if (handler instanceof Orderable && (orderAnnotation = (Order)AnnotationUtils.findAnnotation((Method)method, Order.class)) != null) {
            ((Orderable)handler).setOrder(orderAnnotation.value());
        }
        boolean handlerExists = false;
        if (this.beanAnnotationAware() && AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)Bean.class.getName())) {
            Object handlerBean = this.resolveTargetBeanFromMethodWithBeanAnnotation(method);
            boolean bl = handlerExists = handlerBean != null && handler == handlerBean;
        }
        if (!handlerExists) {
            String handlerBeanName = this.generateHandlerBeanName(beanName, method);
            this.beanFactory.registerSingleton(handlerBeanName, (Object)handler);
            handler = (MessageHandler)this.beanFactory.initializeBean((Object)handler, handlerBeanName);
        }
        if ((endpoint = this.createEndpoint(handler, method, annotations)) != null) {
            return endpoint;
        }
        return handler;
    }

    @Override
    public boolean shouldCreateEndpoint(Method method, List<Annotation> annotations) {
        String inputChannel = MessagingAnnotationUtils.resolveAttribute(annotations, this.getInputChannelAttribute(), String.class);
        boolean createEndpoint = StringUtils.hasText((String)inputChannel);
        if (!createEndpoint && this.beanAnnotationAware()) {
            boolean isBean = AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)Bean.class.getName());
            Assert.isTrue((!isBean ? 1 : 0) != 0, (String)("A channel name in '" + this.getInputChannelAttribute() + "' is required when " + this.annotationType + " is used on '@Bean' methods."));
        }
        return createEndpoint;
    }

    protected String getInputChannelAttribute() {
        return INPUT_CHANNEL_ATTRIBUTE;
    }

    protected boolean beanAnnotationAware() {
        return true;
    }

    protected final void setAdviceChainIfPresent(String beanName, List<Annotation> annotations, MessageHandler handler) {
        String[] adviceChainNames = MessagingAnnotationUtils.resolveAttribute(annotations, ADVICE_CHAIN_ATTRIBUTE, String[].class);
        if (adviceChainNames != null && adviceChainNames.length > 0) {
            if (!(handler instanceof AbstractReplyProducingMessageHandler)) {
                throw new IllegalArgumentException("Cannot apply advice chain to " + handler.getClass().getName());
            }
            ArrayList<Advice> adviceChain = new ArrayList<Advice>();
            for (String adviceChainName : adviceChainNames) {
                Object adviceChainBean = this.beanFactory.getBean(adviceChainName);
                if (adviceChainBean instanceof Advice) {
                    adviceChain.add((Advice)adviceChainBean);
                    continue;
                }
                if (adviceChainBean instanceof Advice[]) {
                    Collections.addAll(adviceChain, (Advice[])adviceChainBean);
                    continue;
                }
                if (adviceChainBean instanceof Collection) {
                    Collection adviceChainEntries = (Collection)adviceChainBean;
                    for (Advice advice : adviceChainEntries) {
                        adviceChain.add(advice);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Invalid advice chain type:" + adviceChainName.getClass().getName() + " for bean '" + beanName + "'");
            }
            ((AbstractReplyProducingMessageHandler)handler).setAdviceChain(adviceChain);
        }
    }

    protected AbstractEndpoint createEndpoint(MessageHandler handler, Method method, List<Annotation> annotations) {
        AbstractEndpoint endpoint = null;
        String inputChannelName = MessagingAnnotationUtils.resolveAttribute(annotations, this.getInputChannelAttribute(), String.class);
        if (StringUtils.hasText((String)inputChannelName)) {
            MessageChannel inputChannel;
            try {
                inputChannel = (MessageChannel)this.channelResolver.resolveDestination(inputChannelName);
            }
            catch (DestinationResolutionException e) {
                inputChannel = new DirectChannel();
                this.beanFactory.registerSingleton(inputChannelName, (Object)inputChannel);
                inputChannel = (MessageChannel)this.beanFactory.initializeBean((Object)inputChannel, inputChannelName);
            }
            Assert.notNull((Object)inputChannel, (String)("failed to resolve inputChannel '" + inputChannelName + "'"));
            endpoint = this.doCreateEndpoint(handler, inputChannel, annotations);
        }
        return endpoint;
    }

    protected AbstractEndpoint doCreateEndpoint(MessageHandler handler, MessageChannel inputChannel, List<Annotation> annotations) {
        AbstractEndpoint endpoint;
        if (inputChannel instanceof PollableChannel) {
            PollingConsumer pollingConsumer = new PollingConsumer((PollableChannel)inputChannel, handler);
            this.configurePollingEndpoint(pollingConsumer, annotations);
            endpoint = pollingConsumer;
        } else {
            Object[] pollers = MessagingAnnotationUtils.resolveAttribute(annotations, "poller", Poller[].class);
            Assert.state((boolean)ObjectUtils.isEmpty((Object[])pollers), (String)("A '@Poller' should not be specified for Annotation-based endpoint, since '" + inputChannel + "' is a SubscribableChannel (not pollable)."));
            endpoint = new EventDrivenConsumer((SubscribableChannel)inputChannel, handler);
        }
        return endpoint;
    }

    protected void configurePollingEndpoint(AbstractPollingEndpoint pollingEndpoint, List<Annotation> annotations) {
        PollerMetadata pollerMetadata = null;
        Object[] pollers = MessagingAnnotationUtils.resolveAttribute(annotations, "poller", Poller[].class);
        if (!ObjectUtils.isEmpty((Object[])pollers)) {
            Assert.state((pollers.length == 1 ? 1 : 0) != 0, (String)"The 'poller' for an Annotation-based endpoint can have only one '@Poller'.");
            Object poller = pollers[0];
            String ref = poller.value();
            String triggerRef = poller.trigger();
            String executorRef = poller.taskExecutor();
            String fixedDelayValue = this.environment.resolvePlaceholders(poller.fixedDelay());
            String fixedRateValue = this.environment.resolvePlaceholders(poller.fixedRate());
            String maxMessagesPerPollValue = this.environment.resolvePlaceholders(poller.maxMessagesPerPoll());
            String cron = this.environment.resolvePlaceholders(poller.cron());
            if (StringUtils.hasText((String)ref)) {
                Assert.state((!StringUtils.hasText((String)triggerRef) && !StringUtils.hasText((String)executorRef) && !StringUtils.hasText((String)cron) && !StringUtils.hasText((String)fixedDelayValue) && !StringUtils.hasText((String)fixedRateValue) && !StringUtils.hasText((String)maxMessagesPerPollValue) ? 1 : 0) != 0, (String)"The '@Poller' 'ref' attribute is mutually exclusive with other attributes.");
                pollerMetadata = (PollerMetadata)this.beanFactory.getBean(ref, PollerMetadata.class);
            } else {
                pollerMetadata = new PollerMetadata();
                if (StringUtils.hasText((String)maxMessagesPerPollValue)) {
                    pollerMetadata.setMaxMessagesPerPoll(Long.parseLong(maxMessagesPerPollValue));
                }
                if (StringUtils.hasText((String)executorRef)) {
                    pollerMetadata.setTaskExecutor((Executor)this.beanFactory.getBean(executorRef, TaskExecutor.class));
                }
                Trigger trigger = null;
                if (StringUtils.hasText((String)triggerRef)) {
                    Assert.state((!StringUtils.hasText((String)cron) && !StringUtils.hasText((String)fixedDelayValue) && !StringUtils.hasText((String)fixedRateValue) ? 1 : 0) != 0, (String)"The '@Poller' 'trigger' attribute is mutually exclusive with other attributes.");
                    trigger = (Trigger)this.beanFactory.getBean(triggerRef, Trigger.class);
                } else if (StringUtils.hasText((String)cron)) {
                    Assert.state((!StringUtils.hasText((String)fixedDelayValue) && !StringUtils.hasText((String)fixedRateValue) ? 1 : 0) != 0, (String)"The '@Poller' 'cron' attribute is mutually exclusive with other attributes.");
                    trigger = new CronTrigger(cron);
                } else if (StringUtils.hasText((String)fixedDelayValue)) {
                    Assert.state((!StringUtils.hasText((String)fixedRateValue) ? 1 : 0) != 0, (String)"The '@Poller' 'fixedDelay' attribute is mutually exclusive with other attributes.");
                    trigger = new PeriodicTrigger(Long.parseLong(fixedDelayValue));
                } else if (StringUtils.hasText((String)fixedRateValue)) {
                    trigger = new PeriodicTrigger(Long.parseLong(fixedRateValue));
                    ((PeriodicTrigger)trigger).setFixedRate(true);
                }
                pollerMetadata.setTrigger(trigger);
            }
        } else {
            pollerMetadata = PollerMetadata.getDefaultPollerMetadata((BeanFactory)this.beanFactory);
            Assert.notNull((Object)pollerMetadata, (String)"No poller has been defined for Annotation-based endpoint, and no default poller is available within the context.");
        }
        pollingEndpoint.setTaskExecutor(pollerMetadata.getTaskExecutor());
        pollingEndpoint.setTrigger(pollerMetadata.getTrigger());
        pollingEndpoint.setAdviceChain(pollerMetadata.getAdviceChain());
        pollingEndpoint.setMaxMessagesPerPoll(pollerMetadata.getMaxMessagesPerPoll());
        pollingEndpoint.setErrorHandler(pollerMetadata.getErrorHandler());
        if (pollingEndpoint instanceof PollingConsumer) {
            ((PollingConsumer)pollingEndpoint).setReceiveTimeout(pollerMetadata.getReceiveTimeout());
        }
        pollingEndpoint.setTransactionSynchronizationFactory(pollerMetadata.getTransactionSynchronizationFactory());
    }

    protected String generateHandlerBeanName(String originalBeanName, Method method) {
        String baseName;
        String name = baseName = originalBeanName + "." + method.getName() + "." + ClassUtils.getShortNameAsProperty(this.annotationType);
        int count = 1;
        while (this.beanFactory.containsBean(name)) {
            name = baseName + "#" + ++count;
        }
        return name + ".handler";
    }

    protected void setOutputChannelIfPresent(List<Annotation> annotations, AbstractReplyProducingMessageHandler handler) {
        String outputChannelName = MessagingAnnotationUtils.resolveAttribute(annotations, "outputChannel", String.class);
        if (StringUtils.hasText((String)outputChannelName)) {
            handler.setOutputChannel((MessageChannel)this.channelResolver.resolveDestination(outputChannelName));
        }
    }

    protected Object resolveTargetBeanFromMethodWithBeanAnnotation(Method method) {
        Object id = null;
        Object[] names = ((Bean)AnnotationUtils.getAnnotation((Method)method, Bean.class)).name();
        if (!ObjectUtils.isEmpty((Object[])names)) {
            id = names[0];
        }
        if (!StringUtils.hasText(id)) {
            id = method.getName();
        }
        return this.beanFactory.getBean((String)id);
    }

    <H> H extractTypeIfPossible(Object targetObject, Class<H> expectedType) {
        if (targetObject == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(targetObject.getClass())) {
            return (H)targetObject;
        }
        if (targetObject instanceof Advised) {
            TargetSource targetSource = ((Advised)targetObject).getTargetSource();
            if (targetSource == null) {
                return null;
            }
            try {
                return this.extractTypeIfPossible(targetSource.getTarget(), expectedType);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    protected abstract MessageHandler createHandler(Object var1, Method var2, List<Annotation> var3);
}

