/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.integration.aggregator.AggregatingMessageHandler;
import org.springframework.integration.aggregator.MethodInvokingCorrelationStrategy;
import org.springframework.integration.aggregator.MethodInvokingMessageGroupProcessor;
import org.springframework.integration.aggregator.MethodInvokingReleaseStrategy;
import org.springframework.integration.annotation.Aggregator;
import org.springframework.integration.annotation.CorrelationStrategy;
import org.springframework.integration.annotation.ReleaseStrategy;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.config.annotation.MessagingAnnotationUtils;
import org.springframework.integration.store.SimpleMessageStore;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AggregatorAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<Aggregator> {
    public AggregatorAnnotationPostProcessor(ListableBeanFactory beanFactory, Environment environment) {
        super(beanFactory, environment);
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        Boolean sendPartialResultsOnExpiry;
        Long sendTimeout;
        String outputChannelName;
        MethodInvokingMessageGroupProcessor processor = new MethodInvokingMessageGroupProcessor(bean, method);
        processor.setBeanFactory((BeanFactory)this.beanFactory);
        MethodInvokingReleaseStrategy releaseStrategy = null;
        Method releaseStrategyMethod = MessagingAnnotationUtils.findAnnotatedMethod(bean, ReleaseStrategy.class);
        if (releaseStrategyMethod != null) {
            releaseStrategy = new MethodInvokingReleaseStrategy(bean, releaseStrategyMethod);
        }
        MethodInvokingCorrelationStrategy correlationStrategy = null;
        Method correlationStrategyMethod = MessagingAnnotationUtils.findAnnotatedMethod(bean, CorrelationStrategy.class);
        if (correlationStrategyMethod != null) {
            correlationStrategy = new MethodInvokingCorrelationStrategy(bean, correlationStrategyMethod);
        }
        AggregatingMessageHandler handler = new AggregatingMessageHandler(processor, new SimpleMessageStore(), correlationStrategy, releaseStrategy);
        String discardChannelName = MessagingAnnotationUtils.resolveAttribute(annotations, "discardChannel", String.class);
        if (StringUtils.hasText((String)discardChannelName)) {
            MessageChannel discardChannel = (MessageChannel)this.channelResolver.resolveDestination(discardChannelName);
            Assert.notNull((Object)discardChannel, (String)("failed to resolve discardChannel '" + discardChannelName + "'"));
            handler.setDiscardChannel(discardChannel);
        }
        if (StringUtils.hasText((String)(outputChannelName = MessagingAnnotationUtils.resolveAttribute(annotations, "outputChannel", String.class)))) {
            handler.setOutputChannel((MessageChannel)this.channelResolver.resolveDestination(outputChannelName));
        }
        if ((sendTimeout = MessagingAnnotationUtils.resolveAttribute(annotations, "sendTimeout", Long.class)) != null) {
            handler.setSendTimeout(sendTimeout);
        }
        if ((sendPartialResultsOnExpiry = MessagingAnnotationUtils.resolveAttribute(annotations, "sendPartialResultsOnExpiry", Boolean.class)) != null) {
            handler.setSendPartialResultOnExpiry(sendPartialResultsOnExpiry);
        }
        handler.setBeanFactory((BeanFactory)this.beanFactory);
        handler.afterPropertiesSet();
        return handler;
    }

    @Override
    protected boolean beanAnnotationAware() {
        return false;
    }
}

