/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.integration.annotation.Filter;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.config.annotation.MessagingAnnotationUtils;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.filter.MessageFilter;
import org.springframework.integration.filter.MethodInvokingSelector;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FilterAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<Filter> {
    public FilterAnnotationPostProcessor(ListableBeanFactory beanFactory, Environment environment) {
        super(beanFactory, environment);
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        MessageSelector selector;
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)Bean.class.getName())) {
            Object target = this.resolveTargetBeanFromMethodWithBeanAnnotation(method);
            if (target instanceof MessageSelector) {
                selector = (MessageSelector)target;
            } else {
                if (this.extractTypeIfPossible(target, MessageFilter.class) != null) {
                    return (MessageHandler)target;
                }
                selector = new MethodInvokingSelector(target);
            }
        } else {
            Assert.isTrue((Boolean.TYPE.equals(method.getReturnType()) || Boolean.class.equals(method.getReturnType()) ? 1 : 0) != 0, (String)"The Filter annotation may only be applied to methods with a boolean return type.");
            selector = new MethodInvokingSelector(bean, method);
        }
        MessageFilter filter = new MessageFilter(selector);
        filter.setDiscardWithinAdvice(MessagingAnnotationUtils.resolveAttribute(annotations, "discardWithinAdvice", Boolean.class));
        String throwExceptionOnRejection = MessagingAnnotationUtils.resolveAttribute(annotations, "throwExceptionOnRejection", String.class);
        if (StringUtils.hasText((String)throwExceptionOnRejection)) {
            String throwExceptionOnRejectionValue = this.environment.resolvePlaceholders(throwExceptionOnRejection);
            filter.setThrowExceptionOnRejection(Boolean.parseBoolean(throwExceptionOnRejectionValue));
        }
        String discardChannelName = MessagingAnnotationUtils.resolveAttribute(annotations, "discardChannel", String.class);
        filter.setDiscardChannelName(discardChannelName);
        this.setOutputChannelIfPresent(annotations, filter);
        return filter;
    }
}

