/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.integration.annotation.InboundChannelAdapter;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.config.annotation.MessagingAnnotationUtils;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.MethodInvokingMessageSource;
import org.springframework.integration.endpoint.SourcePollingChannelAdapter;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;

public class InboundChannelAdapterAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<InboundChannelAdapter> {
    public InboundChannelAdapterAnnotationPostProcessor(ListableBeanFactory beanFactory, Environment environment) {
        super(beanFactory, environment);
    }

    @Override
    protected String getInputChannelAttribute() {
        return "value";
    }

    @Override
    public Object postProcess(Object bean, String beanName, Method method, List<Annotation> annotations) {
        String channelName = MessagingAnnotationUtils.resolveAttribute(annotations, "value", String.class);
        Assert.hasText((String)channelName, (String)"The channel ('value' attribute of @InboundChannelAdapter) can't be empty.");
        MessageSource<?> messageSource = this.createMessageSource(bean, beanName, method);
        MessageChannel channel = (MessageChannel)this.channelResolver.resolveDestination(channelName);
        SourcePollingChannelAdapter adapter = new SourcePollingChannelAdapter();
        adapter.setOutputChannel(channel);
        adapter.setSource(messageSource);
        this.configurePollingEndpoint(adapter, annotations);
        return adapter;
    }

    private MessageSource<?> createMessageSource(Object bean, String beanName, Method method) {
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)Bean.class.getName())) {
            Object target = this.resolveTargetBeanFromMethodWithBeanAnnotation(method);
            Assert.isInstanceOf(MessageSource.class, (Object)target, (String)("The '" + this.annotationType + "' on @Bean method " + "level is allowed only for: " + MessageSource.class.getName() + "beans"));
            return (MessageSource)target;
        }
        MethodInvokingMessageSource messageSource = new MethodInvokingMessageSource();
        messageSource.setObject(bean);
        messageSource.setMethod(method);
        String messageSourceBeanName = this.generateHandlerBeanName(beanName, method);
        this.beanFactory.registerSingleton(messageSourceBeanName, (Object)messageSource);
        return (MessageSource)this.beanFactory.initializeBean((Object)messageSource, messageSourceBeanName);
    }

    @Override
    protected String generateHandlerBeanName(String originalBeanName, Method method) {
        return super.generateHandlerBeanName(originalBeanName, method).replaceFirst(".handler$", ".source");
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        throw new UnsupportedOperationException();
    }
}

