/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.config.annotation.MessagingAnnotationUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.StringUtils;

public class ServiceActivatorAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<ServiceActivator> {
    public ServiceActivatorAnnotationPostProcessor(ListableBeanFactory beanFactory, Environment environment) {
        super(beanFactory, environment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        String requiresReply;
        AbstractReplyProducingMessageHandler serviceActivator;
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)Bean.class.getName())) {
            final Object target = this.resolveTargetBeanFromMethodWithBeanAnnotation(method);
            serviceActivator = this.extractTypeIfPossible(target, AbstractReplyProducingMessageHandler.class);
            if (serviceActivator != null) return (MessageHandler)target;
            if (target instanceof MessageHandler) {
                return new AbstractReplyProducingMessageHandler(){

                    @Override
                    protected Object handleRequestMessage(Message<?> requestMessage) {
                        ((MessageHandler)target).handleMessage(requestMessage);
                        return null;
                    }
                };
            }
            serviceActivator = new ServiceActivatingHandler(target);
        } else {
            serviceActivator = new ServiceActivatingHandler(bean, method);
        }
        if (StringUtils.hasText((String)(requiresReply = MessagingAnnotationUtils.resolveAttribute(annotations, "requiresReply", String.class)))) {
            serviceActivator.setRequiresReply(Boolean.parseBoolean(this.environment.resolvePlaceholders(requiresReply)));
        }
        this.setOutputChannelIfPresent(annotations, serviceActivator);
        return serviceActivator;
    }
}

