/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.integration.annotation.Splitter;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.config.annotation.MessagingAnnotationUtils;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.integration.splitter.MethodInvokingSplitter;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SplitterAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<Splitter> {
    public SplitterAnnotationPostProcessor(ListableBeanFactory beanFactory, Environment environment) {
        super(beanFactory, environment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        String applySequenceValue;
        AbstractMessageSplitter splitter;
        String applySequence = MessagingAnnotationUtils.resolveAttribute(annotations, "applySequence", String.class);
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)Bean.class.getName())) {
            Object target = this.resolveTargetBeanFromMethodWithBeanAnnotation(method);
            splitter = this.extractTypeIfPossible(target, AbstractMessageSplitter.class);
            if (splitter != null) return splitter;
            if (target instanceof MessageHandler) {
                Assert.hasText((String)applySequence, (String)("'applySequence' can be applied to 'AbstractMessageSplitter', but target handler is: " + target.getClass()));
                return (MessageHandler)target;
            }
            splitter = new MethodInvokingSplitter(target);
        } else {
            splitter = new MethodInvokingSplitter(bean, method);
        }
        if (StringUtils.hasText((String)applySequence) && StringUtils.hasText((String)(applySequenceValue = this.environment.resolvePlaceholders(applySequence)))) {
            splitter.setApplySequence(Boolean.parseBoolean(applySequenceValue));
        }
        this.setOutputChannelIfPresent(annotations, splitter);
        return splitter;
    }
}

