/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.integration.transformer.MethodInvokingTransformer;
import org.springframework.integration.transformer.Transformer;
import org.springframework.messaging.MessageHandler;

public class TransformerAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<org.springframework.integration.annotation.Transformer> {
    public TransformerAnnotationPostProcessor(ListableBeanFactory beanFactory, Environment environment) {
        super(beanFactory, environment);
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        Transformer transformer;
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)Bean.class.getName())) {
            Object target = this.resolveTargetBeanFromMethodWithBeanAnnotation(method);
            transformer = this.extractTypeIfPossible(target, Transformer.class);
            if (transformer == null) {
                if (this.extractTypeIfPossible(target, AbstractReplyProducingMessageHandler.class) != null) {
                    return (MessageHandler)target;
                }
                transformer = new MethodInvokingTransformer(target);
            }
        } else {
            transformer = new MethodInvokingTransformer(bean, method);
        }
        MessageTransformingHandler handler = new MessageTransformingHandler(transformer);
        this.setOutputChannelIfPresent(annotations, handler);
        return handler;
    }
}

