/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.transformer.ContentEnricher;
import org.springframework.integration.transformer.support.ExpressionEvaluatingHeaderValueMessageProcessor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class EnricherParser
extends AbstractConsumerEndpointParser {
    @Override
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        String name;
        ManagedMap expressions;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ContentEnricher.class);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, "request-channel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, "reply-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "request-timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "reply-timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "requires-reply");
        List subElements = DomUtils.getChildElementsByTagName((Element)element, (String)"property");
        if (!CollectionUtils.isEmpty((Collection)subElements)) {
            expressions = new ManagedMap();
            for (Element subElement : subElements) {
                AbstractBeanDefinition expressionDef;
                name = subElement.getAttribute("name");
                String value = subElement.getAttribute("value");
                String type = subElement.getAttribute("type");
                String expression = subElement.getAttribute("expression");
                boolean hasAttributeValue = StringUtils.hasText((String)value);
                boolean hasAttributeExpression = StringUtils.hasText((String)expression);
                if (hasAttributeValue && hasAttributeExpression) {
                    parserContext.getReaderContext().error("Only one of 'value' or 'expression' is allowed", (Object)element);
                }
                if (!hasAttributeValue && !hasAttributeExpression) {
                    parserContext.getReaderContext().error("One of 'value' or 'expression' is required", (Object)element);
                }
                if (hasAttributeValue) {
                    BeanDefinitionBuilder expressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ValueExpression.class);
                    if (StringUtils.hasText((String)type)) {
                        expressionBuilder.addConstructorArgValue((Object)new TypedStringValue(value, type));
                    } else {
                        expressionBuilder.addConstructorArgValue((Object)value);
                    }
                    expressionDef = expressionBuilder.getBeanDefinition();
                } else {
                    if (StringUtils.hasText((String)type)) {
                        parserContext.getReaderContext().error("The 'type' attribute for '<property>' of '<enricher>' is not allowed with an 'expression' attribute.", (Object)element);
                    }
                    expressionDef = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class).addConstructorArgValue((Object)expression).getBeanDefinition();
                }
                expressions.put((Object)name, (Object)expressionDef);
            }
            builder.addPropertyValue("propertyExpressions", (Object)expressions);
        }
        if (!CollectionUtils.isEmpty((Collection)(subElements = DomUtils.getChildElementsByTagName((Element)element, (String)"header")))) {
            expressions = new ManagedMap();
            for (Element subElement : subElements) {
                name = subElement.getAttribute("name");
                BeanDefinition expressionDefinition = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression("value", "expression", parserContext, subElement, true);
                if (StringUtils.hasText((String)subElement.getAttribute("expression")) && StringUtils.hasText((String)subElement.getAttribute("type"))) {
                    parserContext.getReaderContext().warning("The use of a 'type' attribute is deprecated since 4.0 when using 'expression'", (Object)element);
                }
                BeanDefinitionBuilder valueProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionEvaluatingHeaderValueMessageProcessor.class).addConstructorArgValue((Object)expressionDefinition).addConstructorArgValue((Object)subElement.getAttribute("type"));
                IntegrationNamespaceUtils.setValueIfAttributeDefined(valueProcessorBuilder, subElement, "overwrite");
                expressions.put((Object)name, (Object)valueProcessorBuilder.getBeanDefinition());
            }
            builder.addPropertyValue("headerExpressions", (Object)expressions);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "should-clone-payload");
        String requestPayloadExpression = element.getAttribute("request-payload-expression");
        if (StringUtils.hasText((String)requestPayloadExpression)) {
            BeanDefinitionBuilder expressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
            expressionBuilder.addConstructorArgValue((Object)requestPayloadExpression);
            builder.addPropertyValue("requestPayloadExpression", (Object)expressionBuilder.getBeanDefinition());
        }
        return builder;
    }
}

