/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpelPropertyAccessorsParser
implements BeanDefinitionParser {
    private final Map<String, Object> propertyAccessors = new ManagedMap();
    private volatile boolean initialized;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.initializeSpelPropertyAccessorRegistrarIfNecessary(parserContext);
        BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String propertyAccessorName = null;
            BeanDefinitionHolder propertyAccessor = null;
            if (!(node instanceof Element) || delegate.nodeNameEquals(node, "description")) continue;
            Element ele = (Element)node;
            if (delegate.nodeNameEquals((Node)ele, "bean")) {
                propertyAccessorName = ele.getAttribute("id");
                if (!StringUtils.hasText((String)propertyAccessorName)) {
                    parserContext.getReaderContext().error("The '<bean>' 'id' attribute is required within 'spel-property-accessors'.", (Object)ele);
                    return null;
                }
                propertyAccessor = delegate.parseBeanDefinitionElement(ele);
            } else if (delegate.nodeNameEquals((Node)ele, "ref")) {
                BeanReference propertyAccessorRef = (BeanReference)delegate.parsePropertySubElement(ele, null);
                propertyAccessorName = propertyAccessorRef.getBeanName();
                propertyAccessor = propertyAccessorRef;
            } else {
                parserContext.getReaderContext().error("Only '<bean>' and '<ref>' elements are allowed.", (Object)element);
                return null;
            }
            this.propertyAccessors.put(propertyAccessorName, propertyAccessor);
        }
        return null;
    }

    private synchronized void initializeSpelPropertyAccessorRegistrarIfNecessary(ParserContext parserContext) {
        if (!this.initialized) {
            BeanDefinitionBuilder registrarBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.config.SpelPropertyAccessorRegistrar").setRole(2).addConstructorArgValue(this.propertyAccessors);
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)registrarBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
            this.initialized = true;
        }
    }
}

