/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.context;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.context.IntegrationProperties;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class IntegrationObjectSupport
implements BeanNameAware,
NamedComponent,
ApplicationContextAware,
BeanFactoryAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ConversionService defaultConversionService = new DefaultConversionService();
    private volatile String beanName;
    private volatile String componentName;
    private volatile BeanFactory beanFactory;
    private volatile TaskScheduler taskScheduler;
    private volatile Properties integrationProperties = IntegrationProperties.defaults();
    private volatile ConversionService conversionService;
    private volatile ApplicationContext applicationContext;
    private volatile MessageBuilderFactory messageBuilderFactory;

    public final void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public final String getComponentName() {
        return StringUtils.hasText((String)this.componentName) ? this.componentName : this.beanName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public String getComponentType() {
        return null;
    }

    public final void setBeanFactory(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"'beanFactory' must not be null");
        this.beanFactory = beanFactory;
        this.integrationProperties = IntegrationContextUtils.getIntegrationProperties(this.beanFactory);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.notNull((Object)applicationContext, (String)"'applicationContext' must not be null");
        this.applicationContext = applicationContext;
    }

    public final void afterPropertiesSet() {
        try {
            if (this.messageBuilderFactory == null) {
                this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(this.beanFactory);
            }
            this.onInit();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BeanInitializationException("failed to initialize", (Throwable)e);
        }
    }

    protected void onInit() throws Exception {
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected TaskScheduler getTaskScheduler() {
        if (this.taskScheduler == null && this.beanFactory != null) {
            this.taskScheduler = IntegrationContextUtils.getTaskScheduler(this.beanFactory);
        }
        return this.taskScheduler;
    }

    protected void setTaskScheduler(TaskScheduler taskScheduler) {
        Assert.notNull((Object)taskScheduler, (String)"taskScheduler must not be null");
        this.taskScheduler = taskScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConversionService getConversionService() {
        if (this.conversionService == null && this.beanFactory != null) {
            IntegrationObjectSupport integrationObjectSupport = this;
            synchronized (integrationObjectSupport) {
                if (this.conversionService == null) {
                    this.conversionService = IntegrationUtils.getConversionService(this.beanFactory);
                }
            }
            if (this.conversionService == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to attempt conversion of Message payload types. Component '" + this.getComponentName() + "' has no explicit ConversionService reference, " + "and there is no 'integrationConversionService' bean within the context."));
            }
        }
        return this.conversionService;
    }

    protected void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public String getApplicationContextId() {
        return this.applicationContext == null ? null : this.applicationContext.getId();
    }

    protected Properties getIntegrationProperties() {
        return this.integrationProperties;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (this.messageBuilderFactory == null) {
            this.messageBuilderFactory = new DefaultMessageBuilderFactory();
        }
        return this.messageBuilderFactory;
    }

    public void setMessageBuilderFactory(MessageBuilderFactory messageBuilderFactory) {
        this.messageBuilderFactory = messageBuilderFactory;
    }

    protected <T> T getIntegrationProperty(String key, Class<T> tClass) {
        return (T)this.defaultConversionService.convert((Object)this.integrationProperties.getProperty(key), tClass);
    }

    public String toString() {
        return this.beanName != null ? this.beanName : super.toString();
    }
}

