/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.core;

import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.core.GenericMessagingTemplate;

public class MessagingTemplate
extends GenericMessagingTemplate {
    public MessagingTemplate() {
    }

    public MessagingTemplate(MessageChannel defaultChannel) {
        this.setDefaultChannel(defaultChannel);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setDestinationResolver((DestinationResolver)new BeanFactoryChannelResolver(beanFactory));
        Properties integrationProperties = IntegrationContextUtils.getIntegrationProperties(beanFactory);
        Boolean throwExceptionOnLateReply = Boolean.valueOf(integrationProperties.getProperty("spring.integraton.messagingTemplate.throwExceptionOnLateReply"));
        this.setThrowExceptionOnLateReply(throwExceptionOnLateReply);
    }

    public void setDefaultChannel(MessageChannel channel) {
        super.setDefaultDestination((Object)channel);
    }
}

