/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.Set;
import java.util.concurrent.Executor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class BroadcastingDispatcher
extends AbstractDispatcher
implements BeanFactoryAware {
    private final boolean requireSubscribers;
    private volatile boolean ignoreFailures;
    private volatile boolean applySequence;
    private final Executor executor;
    private volatile int minSubscribers;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();

    public BroadcastingDispatcher() {
        this(null, false);
    }

    public BroadcastingDispatcher(Executor executor) {
        this(executor, false);
    }

    public BroadcastingDispatcher(boolean requireSubscribers) {
        this(null, requireSubscribers);
    }

    public BroadcastingDispatcher(Executor executor, boolean requireSubscribers) {
        this.requireSubscribers = requireSubscribers;
        this.executor = executor;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    public void setMinSubscribers(int minSubscribers) {
        this.minSubscribers = minSubscribers;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(beanFactory);
    }

    @Override
    public boolean dispatch(Message<?> message) {
        int dispatched = 0;
        int sequenceNumber = 1;
        Set<MessageHandler> handlers = this.getHandlers();
        if (this.requireSubscribers && handlers.size() == 0) {
            throw new MessageDispatchingException(message, "Dispatcher has no subscribers");
        }
        int sequenceSize = handlers.size();
        for (final MessageHandler handler : handlers) {
            Message<?> messageToSend;
            Message<?> message2 = messageToSend = !this.applySequence ? message : this.messageBuilderFactory.fromMessage(message).pushSequenceDetails(message.getHeaders().getId(), sequenceNumber++, sequenceSize).build();
            if (this.executor != null) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        BroadcastingDispatcher.this.invokeHandler(handler, messageToSend);
                    }
                });
                ++dispatched;
                continue;
            }
            if (!this.invokeHandler(handler, messageToSend)) continue;
            ++dispatched;
        }
        if (dispatched == 0 && this.minSubscribers == 0 && this.logger.isDebugEnabled()) {
            if (sequenceSize > 0) {
                this.logger.debug((Object)"No subscribers received message, default behavior is ignore");
            } else {
                this.logger.debug((Object)"No subscribers, default behavior is ignore");
            }
        }
        return dispatched >= this.minSubscribers;
    }

    private boolean invokeHandler(MessageHandler handler, Message<?> message) {
        try {
            handler.handleMessage(message);
            return true;
        }
        catch (RuntimeException e) {
            if (!this.ignoreFailures) {
                if (e instanceof MessagingException && ((MessagingException)((Object)e)).getFailedMessage() == null) {
                    throw new MessagingException(message, (Throwable)e);
                }
                throw e;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Suppressing Exception since 'ignoreFailures' is set to TRUE.", (Throwable)e);
            }
            return false;
        }
    }
}

