/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.IntegrationEvaluationContextAware;

public abstract class ExpressionMessageProducerSupport
extends MessageProducerSupport
implements IntegrationEvaluationContextAware {
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private volatile Expression payloadExpression;
    private volatile EvaluationContext evaluationContext;

    public void setPayloadExpression(String payloadExpression) {
        this.payloadExpression = payloadExpression == null ? null : this.parser.parseExpression(payloadExpression);
    }

    @Override
    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext(this.getBeanFactory());
        }
    }

    protected Object evaluatePayloadExpression(Object payload) {
        Object evaluationResult = payload;
        if (this.payloadExpression != null) {
            evaluationResult = this.payloadExpression.getValue(this.evaluationContext, payload);
        }
        return evaluationResult;
    }
}

