/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.expression;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.util.Assert;

public final class ExpressionEvalMap
extends AbstractMap<String, Object> {
    public static final EvaluationCallback SIMPLE_CALLBACK = new EvaluationCallback(){

        @Override
        public Object evaluate(Expression expression) {
            return expression.getValue();
        }
    };
    private final Map<String, ?> original;
    private final EvaluationCallback evaluationCallback;

    private ExpressionEvalMap(Map<String, ?> original, EvaluationCallback evaluationCallback) {
        this.original = original;
        this.evaluationCallback = evaluationCallback;
    }

    @Override
    public Object get(Object key) {
        Object value = this.original.get(key);
        if (value != null) {
            Expression expression;
            if (value instanceof Expression) {
                expression = (Expression)value;
            } else if (value instanceof String) {
                expression = new LiteralExpression((String)value);
            } else {
                throw new IllegalArgumentException("Values must be 'java.lang.String' or 'org.springframework.expression.Expression'; the value type for key " + key + " is : " + value.getClass());
            }
            return this.evaluationCallback.evaluate(expression);
        }
        return null;
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.original.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.original.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean equals(Object o) {
        return this.original.equals(o);
    }

    @Override
    public int hashCode() {
        return this.original.hashCode();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.original.toString();
    }

    public static ExpressionEvalMapBuilder from(Map<String, ?> expressions) {
        Assert.notNull(expressions, (String)"'expressions' must not be null.");
        return new ExpressionEvalMapBuilder(expressions);
    }

    public static interface ExpressionEvalMapComponentsBuilder
    extends ExpressionEvalMapFinalBuilder {
        public ExpressionEvalMapComponentsBuilder usingEvaluationContext(EvaluationContext var1);

        public ExpressionEvalMapComponentsBuilder withRoot(Object var1);

        public ExpressionEvalMapComponentsBuilder withReturnType(Class<?> var1);
    }

    public static interface ExpressionEvalMapFinalBuilder {
        public ExpressionEvalMap build();
    }

    public static final class ExpressionEvalMapBuilder {
        private final Map<String, ?> expressions;
        private EvaluationCallback evaluationCallback;
        private EvaluationContext context;
        private Object root;
        private Class<?> returnType;
        private final ExpressionEvalMapComponentsBuilder evalMapComponentsBuilder = new ExpressionEvalMapComponentsBuilderImpl();
        private final ExpressionEvalMapFinalBuilder finalBuilder = new ExpressionEvalMapFinalBuilderImpl();

        private ExpressionEvalMapBuilder(Map<String, ?> expressions) {
            this.expressions = expressions;
        }

        public ExpressionEvalMapFinalBuilder usingCallback(EvaluationCallback callback) {
            this.evaluationCallback = callback;
            return this.finalBuilder;
        }

        public ExpressionEvalMapFinalBuilder usingSimpleCallback() {
            return this.usingCallback(SIMPLE_CALLBACK);
        }

        public ExpressionEvalMapComponentsBuilder usingEvaluationContext(EvaluationContext context) {
            this.context = context;
            return this.evalMapComponentsBuilder;
        }

        public ExpressionEvalMapComponentsBuilder withRoot(Object root) {
            this.root = root;
            return this.evalMapComponentsBuilder;
        }

        public ExpressionEvalMapComponentsBuilder withReturnType(Class<?> returnType) {
            this.returnType = returnType;
            return this.evalMapComponentsBuilder;
        }

        private class ExpressionEvalMapComponentsBuilderImpl
        extends ExpressionEvalMapFinalBuilderImpl
        implements ExpressionEvalMapComponentsBuilder {
            private ExpressionEvalMapComponentsBuilderImpl() {
            }

            @Override
            public ExpressionEvalMapComponentsBuilder usingEvaluationContext(EvaluationContext context) {
                return ExpressionEvalMapBuilder.this.usingEvaluationContext(context);
            }

            @Override
            public ExpressionEvalMapComponentsBuilder withRoot(Object root) {
                return ExpressionEvalMapBuilder.this.withRoot(root);
            }

            @Override
            public ExpressionEvalMapComponentsBuilder withReturnType(Class<?> returnType) {
                return ExpressionEvalMapBuilder.this.withReturnType(returnType);
            }
        }

        private class ExpressionEvalMapFinalBuilderImpl
        implements ExpressionEvalMapFinalBuilder {
            private ExpressionEvalMapFinalBuilderImpl() {
            }

            @Override
            public ExpressionEvalMap build() {
                if (ExpressionEvalMapBuilder.this.evaluationCallback != null) {
                    return new ExpressionEvalMap(ExpressionEvalMapBuilder.this.expressions, ExpressionEvalMapBuilder.this.evaluationCallback);
                }
                return new ExpressionEvalMap(ExpressionEvalMapBuilder.this.expressions, new ComponentsEvaluationCallback(ExpressionEvalMapBuilder.this.context, ExpressionEvalMapBuilder.this.root, ExpressionEvalMapBuilder.this.returnType));
            }
        }
    }

    public static class ComponentsEvaluationCallback
    implements EvaluationCallback {
        private final EvaluationContext context;
        private final Object root;
        private final Class<?> returnType;

        public ComponentsEvaluationCallback(EvaluationContext context, Object root, Class<?> returnType) {
            this.context = context;
            this.root = root;
            this.returnType = returnType;
        }

        @Override
        public Object evaluate(Expression expression) {
            if (this.context != null) {
                return expression.getValue(this.context, this.root, this.returnType);
            }
            return expression.getValue(this.root, this.returnType);
        }
    }

    public static interface EvaluationCallback {
        public Object evaluate(Expression var1);
    }
}

