/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.filter;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

abstract class AbstractMessageProcessingSelector
implements MessageSelector,
BeanFactoryAware {
    private final MessageProcessor<Boolean> messageProcessor;

    public AbstractMessageProcessingSelector(MessageProcessor<Boolean> messageProcessor) {
        Assert.notNull(messageProcessor, (String)"messageProcessor must not be null");
        this.messageProcessor = messageProcessor;
    }

    protected void setConversionService(ConversionService conversionService) {
        if (this.messageProcessor instanceof AbstractMessageProcessor) {
            ((AbstractMessageProcessor)this.messageProcessor).setConversionService(conversionService);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.messageProcessor instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.messageProcessor).setBeanFactory(beanFactory);
        }
    }

    @Override
    public final boolean accept(Message<?> message) {
        Boolean result = this.messageProcessor.processMessage(message);
        Assert.notNull((Object)result, (String)"result must not be null");
        Assert.isAssignable(Boolean.class, result.getClass(), (String)"a boolean result is required");
        return result;
    }
}

