/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.filter;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.MessageRejectedException;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.filter.AbstractMessageProcessingSelector;
import org.springframework.integration.handler.AbstractReplyProducingPostProcessingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MessageFilter
extends AbstractReplyProducingPostProcessingMessageHandler {
    private final MessageSelector selector;
    private volatile boolean throwExceptionOnRejection;
    private volatile MessageChannel discardChannel;
    private volatile String discardChannelName;

    public MessageFilter(MessageSelector selector) {
        Assert.notNull((Object)selector, (String)"selector must not be null");
        this.selector = selector;
    }

    public void setThrowExceptionOnRejection(boolean throwExceptionOnRejection) {
        this.throwExceptionOnRejection = throwExceptionOnRejection;
    }

    public void setDiscardChannel(MessageChannel discardChannel) {
        this.discardChannel = discardChannel;
    }

    public void setDiscardChannelName(String discardChannelName) {
        this.discardChannelName = discardChannelName;
    }

    public void setDiscardWithinAdvice(boolean discardWithinAdvice) {
        this.setPostProcessWithinAdvice(discardWithinAdvice);
    }

    @Override
    public String getComponentType() {
        return "filter";
    }

    @Override
    protected void doInit() {
        if (StringUtils.hasText((String)this.discardChannelName)) {
            Assert.isNull((Object)this.discardChannel, (String)"'outputChannelName' and 'discardChannel' are mutually exclusive.");
            try {
                this.discardChannel = (MessageChannel)this.getBeanFactory().getBean(this.discardChannelName, MessageChannel.class);
            }
            catch (BeansException e) {
                throw new DestinationResolutionException("Failed to look up MessageChannel with name '" + this.discardChannelName + "' in the BeanFactory.");
            }
        }
        if (this.selector instanceof AbstractMessageProcessingSelector) {
            ((AbstractMessageProcessingSelector)this.selector).setConversionService(this.getConversionService());
        }
        if (this.selector instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.selector).setBeanFactory(this.getBeanFactory());
        }
    }

    @Override
    protected Object doHandleRequestMessage(Message<?> message) {
        if (this.selector.accept(message)) {
            return message;
        }
        return null;
    }

    @Override
    public Object postProcess(Message<?> message, Object result) {
        if (result == null) {
            if (this.discardChannel != null) {
                this.getMessagingTemplate().send(this.discardChannel, message);
            }
            if (this.throwExceptionOnRejection) {
                throw new MessageRejectedException(message, "MessageFilter '" + this.getComponentName() + "' rejected Message");
            }
        }
        return result;
    }

    @Override
    protected boolean shouldCopyRequestHeaders() {
        return false;
    }
}

