/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gateway;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.support.TaskExecutorAdapter;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.annotation.Gateway;
import org.springframework.integration.annotation.GatewayHeader;
import org.springframework.integration.annotation.Payload;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.gateway.GatewayMethodInboundMessageMapper;
import org.springframework.integration.gateway.GatewayMethodMetadata;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.gateway.MethodArgsMessageMapper;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.integration.history.TrackableComponent;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class GatewayProxyFactoryBean
extends AbstractEndpoint
implements TrackableComponent,
FactoryBean<Object>,
MethodInterceptor,
BeanClassLoaderAware {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private volatile Class<?> serviceInterface;
    private volatile MessageChannel defaultRequestChannel;
    private volatile MessageChannel defaultReplyChannel;
    private volatile MessageChannel errorChannel;
    private volatile Long defaultRequestTimeout;
    private volatile Long defaultReplyTimeout;
    private volatile DestinationResolver<MessageChannel> channelResolver;
    private volatile boolean shouldTrack = false;
    private volatile TypeConverter typeConverter = new SimpleTypeConverter();
    private volatile ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private volatile Object serviceProxy;
    private final Map<Method, MethodInvocationGateway> gatewayMap = new HashMap<Method, MethodInvocationGateway>();
    private volatile AsyncTaskExecutor asyncExecutor = new SimpleAsyncTaskExecutor();
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();
    private volatile Map<String, GatewayMethodMetadata> methodMetadataMap;
    private volatile GatewayMethodMetadata globalMethodMetadata;
    private volatile MethodArgsMessageMapper argsMapper;

    public GatewayProxyFactoryBean() {
    }

    public GatewayProxyFactoryBean(Class<?> serviceInterface) {
        Assert.notNull(serviceInterface, (String)"'serviceInterface' must not be null");
        Assert.isTrue((boolean)serviceInterface.isInterface(), (String)"'serviceInterface' must be an interface");
        this.serviceInterface = serviceInterface;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        Assert.notNull(serviceInterface, (String)"'serviceInterface' must not be null");
        Assert.isTrue((boolean)serviceInterface.isInterface(), (String)"'serviceInterface' must be an interface");
        this.serviceInterface = serviceInterface;
    }

    public void setDefaultRequestChannel(MessageChannel defaultRequestChannel) {
        this.defaultRequestChannel = defaultRequestChannel;
    }

    public void setDefaultReplyChannel(MessageChannel defaultReplyChannel) {
        this.defaultReplyChannel = defaultReplyChannel;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setDefaultRequestTimeout(Long defaultRequestTimeout) {
        this.defaultRequestTimeout = defaultRequestTimeout;
    }

    public void setDefaultReplyTimeout(Long defaultReplyTimeout) {
        this.defaultReplyTimeout = defaultReplyTimeout;
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
        if (!CollectionUtils.isEmpty(this.gatewayMap)) {
            for (MethodInvocationGateway gateway : this.gatewayMap.values()) {
                gateway.setShouldTrack(shouldTrack);
            }
        }
    }

    public void setAsyncExecutor(Executor executor) {
        Assert.notNull((Object)executor, (String)"executor must not be null");
        this.asyncExecutor = executor instanceof AsyncTaskExecutor ? (AsyncTaskExecutor)executor : new TaskExecutorAdapter(executor);
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        Assert.notNull((Object)typeConverter, (String)"typeConverter must not be null");
        this.typeConverter = typeConverter;
    }

    public void setMethodMetadataMap(Map<String, GatewayMethodMetadata> methodMetadataMap) {
        this.methodMetadataMap = methodMetadataMap;
    }

    public void setGlobalMethodMetadata(GatewayMethodMetadata globalMethodMetadata) {
        this.globalMethodMetadata = globalMethodMetadata;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public final void setMapper(MethodArgsMessageMapper mapper) {
        this.argsMapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onInit() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            Method[] methods;
            if (this.initialized) {
                return;
            }
            BeanFactory beanFactory = this.getBeanFactory();
            if (this.channelResolver == null && beanFactory != null) {
                this.channelResolver = new BeanFactoryChannelResolver(beanFactory);
            }
            Class<?> proxyInterface = this.determineServiceInterface();
            for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(proxyInterface)) {
                MethodInvocationGateway gateway = this.createGatewayForMethod(method);
                this.gatewayMap.put(method, gateway);
            }
            this.serviceProxy = new ProxyFactory(proxyInterface, (Interceptor)this).getProxy(this.beanClassLoader);
            this.start();
            this.initialized = true;
        }
    }

    private Class<?> determineServiceInterface() {
        if (this.serviceInterface == null) {
            this.serviceInterface = RequestReplyExchanger.class;
        }
        return this.serviceInterface;
    }

    public Class<?> getObjectType() {
        return this.serviceInterface != null ? this.serviceInterface : null;
    }

    public Object getObject() throws Exception {
        if (this.serviceProxy == null) {
            this.onInit();
            Assert.notNull((Object)this.serviceProxy, (String)"failed to initialize proxy");
        }
        return this.serviceProxy;
    }

    public boolean isSingleton() {
        return true;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (Future.class.isAssignableFrom(invocation.getMethod().getReturnType())) {
            return this.asyncExecutor.submit((Callable)new AsyncInvocationTask(invocation));
        }
        return this.doInvoke(invocation);
    }

    private Object doInvoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (AopUtils.isToStringMethod((Method)method)) {
            return "gateway proxy for service interface [" + this.serviceInterface + "]";
        }
        try {
            return this.invokeGatewayMethod(invocation);
        }
        catch (Throwable e) {
            this.rethrowExceptionCauseIfPossible(e, invocation.getMethod());
            return null;
        }
    }

    private Object invokeGatewayMethod(MethodInvocation invocation) throws Exception {
        if (!this.initialized) {
            this.afterPropertiesSet();
        }
        Method method = invocation.getMethod();
        MethodInvocationGateway gateway = this.gatewayMap.get(method);
        Class<?> returnType = method.getReturnType();
        boolean shouldReturnMessage = Message.class.isAssignableFrom(returnType) || GatewayProxyFactoryBean.hasFutureParameterizedWithMessage(method);
        boolean shouldReply = returnType != Void.TYPE;
        int paramCount = method.getParameterTypes().length;
        Object response = null;
        boolean hasPayloadExpression = method.isAnnotationPresent(Payload.class);
        if (!hasPayloadExpression && this.methodMetadataMap != null) {
            GatewayMethodMetadata metadata = this.methodMetadataMap.get(method.getName());
            boolean bl = hasPayloadExpression = metadata != null && StringUtils.hasText((String)metadata.getPayloadExpression());
        }
        if (paramCount == 0 && !hasPayloadExpression) {
            if (shouldReply) {
                if (shouldReturnMessage) {
                    return gateway.receive();
                }
                response = gateway.receive();
            }
        } else {
            Object[] args = invocation.getArguments();
            if (shouldReply) {
                response = shouldReturnMessage ? gateway.sendAndReceiveMessage(args) : gateway.sendAndReceive(args);
            } else {
                gateway.send(args);
                response = null;
            }
        }
        return response != null ? this.convert(response, returnType) : null;
    }

    private void rethrowExceptionCauseIfPossible(Throwable originalException, Method method) throws Throwable {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        for (Throwable t = originalException; t != null; t = t.getCause()) {
            for (Class<?> exceptionType : exceptionTypes) {
                if (!exceptionType.isAssignableFrom(t.getClass())) continue;
                throw t;
            }
            if (!(t instanceof RuntimeException) || t instanceof MessagingException || t instanceof UndeclaredThrowableException || t instanceof IllegalStateException && "Unexpected exception thrown".equals(t.getMessage())) continue;
            throw t;
        }
        throw originalException;
    }

    private MethodInvocationGateway createGatewayForMethod(Method method) {
        GatewayMethodMetadata methodMetadata;
        Gateway gatewayAnnotation = method.getAnnotation(Gateway.class);
        MessageChannel requestChannel = this.defaultRequestChannel;
        MessageChannel replyChannel = this.defaultReplyChannel;
        Long requestTimeout = this.defaultRequestTimeout;
        Long replyTimeout = this.defaultReplyTimeout;
        String payloadExpression = this.globalMethodMetadata != null ? this.globalMethodMetadata.getPayloadExpression() : null;
        HashMap<String, Expression> headerExpressions = new HashMap<String, Expression>();
        if (gatewayAnnotation != null) {
            String replyChannelName;
            String requestChannelName = gatewayAnnotation.requestChannel();
            if (StringUtils.hasText((String)requestChannelName)) {
                requestChannel = this.resolveChannelName(requestChannelName);
            }
            if (StringUtils.hasText((String)(replyChannelName = gatewayAnnotation.replyChannel()))) {
                replyChannel = this.resolveChannelName(replyChannelName);
            }
            if (requestTimeout == null || gatewayAnnotation.requestTimeout() != Long.MIN_VALUE) {
                requestTimeout = gatewayAnnotation.requestTimeout();
            }
            if (replyTimeout == null || gatewayAnnotation.replyTimeout() != Long.MIN_VALUE) {
                replyTimeout = gatewayAnnotation.replyTimeout();
            }
            if (payloadExpression == null || StringUtils.hasText((String)gatewayAnnotation.payloadExpression())) {
                payloadExpression = gatewayAnnotation.payloadExpression();
            }
            if (!ObjectUtils.isEmpty((Object[])gatewayAnnotation.headers())) {
                for (GatewayHeader gatewayHeader : gatewayAnnotation.headers()) {
                    String value = gatewayHeader.value();
                    String expression = gatewayHeader.expression();
                    String name = gatewayHeader.name();
                    boolean hasValue = StringUtils.hasText((String)value);
                    if (!(hasValue ^ StringUtils.hasText((String)expression))) {
                        throw new BeanDefinitionStoreException("exactly one of 'value' or 'expression' is required on a gateway's header.");
                    }
                    headerExpressions.put(name, (Expression)(hasValue ? new LiteralExpression(value) : PARSER.parseExpression(expression)));
                }
            }
        } else if (this.methodMetadataMap != null && this.methodMetadataMap.size() > 0 && (methodMetadata = this.methodMetadataMap.get(method.getName())) != null) {
            String repTimeout;
            String reqTimeout;
            String replyChannelName;
            String requestChannelName;
            if (StringUtils.hasText((String)methodMetadata.getPayloadExpression())) {
                payloadExpression = methodMetadata.getPayloadExpression();
            }
            if (!CollectionUtils.isEmpty(methodMetadata.getHeaderExpressions())) {
                headerExpressions.putAll(methodMetadata.getHeaderExpressions());
            }
            if (StringUtils.hasText((String)(requestChannelName = methodMetadata.getRequestChannelName()))) {
                requestChannel = this.resolveChannelName(requestChannelName);
            }
            if (StringUtils.hasText((String)(replyChannelName = methodMetadata.getReplyChannelName()))) {
                replyChannel = this.resolveChannelName(replyChannelName);
            }
            if (StringUtils.hasText((String)(reqTimeout = methodMetadata.getRequestTimeout()))) {
                requestTimeout = this.convert(reqTimeout, Long.class);
            }
            if (StringUtils.hasText((String)(repTimeout = methodMetadata.getReplyTimeout()))) {
                replyTimeout = this.convert(repTimeout, Long.class);
            }
        }
        GatewayMethodInboundMessageMapper messageMapper = new GatewayMethodInboundMessageMapper(method, headerExpressions, this.globalMethodMetadata != null ? this.globalMethodMetadata.getHeaderExpressions() : null, this.argsMapper, this.getMessageBuilderFactory());
        if (StringUtils.hasText((String)payloadExpression)) {
            messageMapper.setPayloadExpression(payloadExpression);
        }
        messageMapper.setBeanFactory(this.getBeanFactory());
        MethodInvocationGateway gateway = new MethodInvocationGateway(messageMapper);
        gateway.setErrorChannel(this.errorChannel);
        if (this.getTaskScheduler() != null) {
            gateway.setTaskScheduler(this.getTaskScheduler());
        }
        gateway.setBeanName(this.getComponentName());
        gateway.setRequestChannel(requestChannel);
        gateway.setReplyChannel(replyChannel);
        if (requestTimeout == null) {
            gateway.setRequestTimeout(-1L);
        } else {
            gateway.setRequestTimeout(requestTimeout);
        }
        if (replyTimeout == null) {
            gateway.setReplyTimeout(-1L);
        } else {
            gateway.setReplyTimeout(replyTimeout);
        }
        if (this.getBeanFactory() != null) {
            gateway.setBeanFactory(this.getBeanFactory());
        }
        if (this.shouldTrack) {
            gateway.setShouldTrack(this.shouldTrack);
        }
        gateway.afterPropertiesSet();
        return gateway;
    }

    private MessageChannel resolveChannelName(String channelName) {
        Assert.state((this.channelResolver != null ? 1 : 0) != 0, (String)"ChannelResolver is required");
        MessageChannel channel = (MessageChannel)this.channelResolver.resolveDestination(channelName);
        Assert.notNull((Object)channel, (String)("failed to resolve channel '" + channelName + "'"));
        return channel;
    }

    @Override
    protected void doStart() {
        for (MethodInvocationGateway gateway : this.gatewayMap.values()) {
            gateway.start();
        }
    }

    @Override
    protected void doStop() {
        for (MethodInvocationGateway gateway : this.gatewayMap.values()) {
            gateway.stop();
        }
    }

    private <T> T convert(Object source, Class<T> expectedReturnType) {
        if (Future.class.isAssignableFrom(expectedReturnType)) {
            return (T)source;
        }
        if (this.getConversionService() != null) {
            return (T)this.getConversionService().convert(source, expectedReturnType);
        }
        return (T)this.typeConverter.convertIfNecessary(source, expectedReturnType);
    }

    private static boolean hasFutureParameterizedWithMessage(Method method) {
        Type rawType;
        Type parameterizedType;
        Type[] typeArgs;
        Type returnType;
        if (Future.class.isAssignableFrom(method.getReturnType()) && (returnType = method.getGenericReturnType()) instanceof ParameterizedType && (typeArgs = ((ParameterizedType)returnType).getActualTypeArguments()) != null && typeArgs.length == 1 && (parameterizedType = typeArgs[0]) instanceof ParameterizedType && (rawType = ((ParameterizedType)parameterizedType).getRawType()) instanceof Class) {
            return Message.class.isAssignableFrom((Class)rawType);
        }
        return false;
    }

    private class AsyncInvocationTask
    implements Callable<Object> {
        private final MethodInvocation invocation;

        private AsyncInvocationTask(MethodInvocation invocation) {
            this.invocation = invocation;
        }

        @Override
        public Object call() throws Exception {
            try {
                return GatewayProxyFactoryBean.this.doInvoke(this.invocation);
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new MessagingException("asynchronous gateway invocation failed", t);
            }
        }
    }

    private static class MethodInvocationGateway
    extends MessagingGatewaySupport {
        private MethodInvocationGateway(GatewayMethodInboundMessageMapper messageMapper) {
            this.setRequestMapper(messageMapper);
        }
    }
}

