/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;

public class MessageHandlerChain
extends AbstractMessageHandler
implements MessageProducer,
Lifecycle {
    private volatile List<MessageHandler> handlers;
    private volatile MessageChannel outputChannel;
    private volatile Long sendTimeout = null;
    private volatile DestinationResolver<MessageChannel> channelResolver;
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();
    private volatile boolean running;
    private final ReentrantLock lifecycleLock = new ReentrantLock();

    public void setHandlers(List<MessageHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    @Override
    public String getComponentType() {
        return "chain";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onInit() throws Exception {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (!this.initialized) {
                Assert.notEmpty(this.handlers, (String)"handler list must not be empty");
                this.configureChain();
                BeanFactory beanFactory = this.getBeanFactory();
                if (this.channelResolver == null && beanFactory != null) {
                    this.channelResolver = new BeanFactoryChannelResolver(beanFactory);
                }
                this.initialized = true;
            }
        }
    }

    @Override
    protected void handleMessageInternal(Message<?> message) throws Exception {
        if (!this.initialized) {
            this.onInit();
        }
        this.handlers.get(0).handleMessage(message);
    }

    private void configureChain() {
        Assert.isTrue((this.handlers.size() == new HashSet<MessageHandler>(this.handlers).size() ? 1 : 0) != 0, (String)"duplicate handlers are not allowed in a chain");
        for (int i = 0; i < this.handlers.size(); ++i) {
            MessageHandler handler = this.handlers.get(i);
            if (i < this.handlers.size() - 1) {
                Assert.isTrue((boolean)(handler instanceof MessageProducer), (String)"All handlers except for the last one in the chain must implement the MessageProducer interface.");
                final MessageHandler nextHandler = this.handlers.get(i + 1);
                MessageChannel nextChannel = new MessageChannel(){

                    public boolean send(Message<?> message, long timeout) {
                        return this.send(message);
                    }

                    public boolean send(Message<?> message) {
                        nextHandler.handleMessage(message);
                        return true;
                    }
                };
                ((MessageProducer)handler).setOutputChannel(nextChannel);
                if (!(handler instanceof MessageHandlerChain)) continue;
                new DirectFieldAccessor((Object)handler).setPropertyValue("initialized", (Object)false);
                ((MessageHandlerChain)handler).afterPropertiesSet();
                continue;
            }
            if (handler instanceof MessageProducer) {
                ReplyForwardingMessageChannel replyChannel = new ReplyForwardingMessageChannel();
                ((MessageProducer)handler).setOutputChannel(replyChannel);
                continue;
            }
            Assert.isNull((Object)this.outputChannel, (String)"An output channel was provided, but the final handler in the chain does not implement the MessageProducer interface.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.doStart();
                this.running = true;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("started " + this));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.doStop();
                this.running = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("stopped " + this));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.stop();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    private void doStop() {
        for (MessageHandler handler : this.handlers) {
            if (!(handler instanceof Lifecycle)) continue;
            ((Lifecycle)handler).stop();
        }
    }

    private void doStart() {
        for (MessageHandler handler : this.handlers) {
            if (!(handler instanceof Lifecycle)) continue;
            ((Lifecycle)handler).start();
        }
    }

    private class ReplyForwardingMessageChannel
    implements MessageChannel {
        private ReplyForwardingMessageChannel() {
        }

        public boolean send(Message<?> message) {
            return this.send(message, -1L);
        }

        public boolean send(Message<?> message, long timeout) {
            long l = timeout = MessageHandlerChain.this.sendTimeout != null ? MessageHandlerChain.this.sendTimeout : timeout;
            if (MessageHandlerChain.this.outputChannel != null) {
                return MessageHandlerChain.this.outputChannel.send(message, timeout);
            }
            Object replyChannelHeader = message.getHeaders().getReplyChannel();
            if (replyChannelHeader == null) {
                throw new MessageHandlingException(message, "no replyChannel header available");
            }
            MessageChannel replyChannel = null;
            if (replyChannelHeader instanceof MessageChannel) {
                replyChannel = (MessageChannel)replyChannelHeader;
            } else if (replyChannelHeader instanceof String) {
                Assert.notNull((Object)MessageHandlerChain.this.channelResolver, (String)"ChannelResolver is required");
                replyChannel = (MessageChannel)MessageHandlerChain.this.channelResolver.resolveDestination((String)replyChannelHeader);
            } else {
                throw new MessageHandlingException(message, "invalid replyChannel type [" + replyChannelHeader.getClass() + "]");
            }
            return timeout >= 0L ? replyChannel.send(message, timeout) : replyChannel.send(message);
        }
    }
}

