/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.advice;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;

public abstract class AbstractRequestHandlerAdvice
extends IntegrationObjectSupport
implements MethodInterceptor {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public final Object invoke(final MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object[] arguments = invocation.getArguments();
        boolean isMessageMethod = (method.getName().equals("handleRequestMessage") || method.getName().equals("handleMessage")) && arguments.length == 1 && arguments[0] instanceof Message;
        Object invocationThis = invocation.getThis();
        if (!isMessageMethod) {
            boolean isMessageHandler;
            boolean bl = isMessageHandler = invocationThis != null && MessageHandler.class.isAssignableFrom(invocationThis.getClass());
            if (!isMessageHandler && this.logger.isWarnEnabled()) {
                String clazzName = invocationThis == null ? method.getDeclaringClass().getName() : invocationThis.getClass().getName();
                this.logger.warn((Object)("This advice " + this.getClass().getName() + " can only be used for MessageHandlers; an attempt to advise method '" + method.getName() + "' in '" + clazzName + "' is ignored"));
            }
            return invocation.proceed();
        }
        Message message = (Message)arguments[0];
        try {
            return this.doInvoke(new ExecutionCallback(){

                @Override
                public Object execute() throws Exception {
                    try {
                        return invocation.proceed();
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new ThrowableHolderException(e);
                    }
                }

                @Override
                public Object cloneAndExecute() throws Exception {
                    try {
                        if (invocation instanceof ProxyMethodInvocation) {
                            return ((ProxyMethodInvocation)invocation).invocableClone().proceed();
                        }
                        throw new IllegalStateException("MethodInvocation of the wrong type detected - this should not happen with Spring AOP, so please raise an issue if you see this exception");
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new ThrowableHolderException(e);
                    }
                }
            }, invocationThis, message);
        }
        catch (Exception e) {
            throw this.unwrapThrowableIfNecessary(e);
        }
    }

    protected abstract Object doInvoke(ExecutionCallback var1, Object var2, Message<?> var3) throws Exception;

    protected Exception unwrapExceptionIfNecessary(Exception e) {
        Exception actualException = e;
        if (e instanceof ThrowableHolderException && e.getCause() instanceof Exception) {
            actualException = (Exception)e.getCause();
        }
        return actualException;
    }

    protected Throwable unwrapThrowableIfNecessary(Exception e) {
        Throwable actualThrowable = e;
        if (e instanceof ThrowableHolderException) {
            actualThrowable = e.getCause();
        }
        return actualThrowable;
    }

    private class ThrowableHolderException
    extends RuntimeException {
        public ThrowableHolderException(Throwable cause) {
            super(cause);
        }
    }

    protected static interface ExecutionCallback {
        public Object execute() throws Exception;

        public Object cloneAndExecute() throws Exception;
    }
}

