/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.integration.router.MappingMessageRouterManagement;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractMappingMessageRouter
extends AbstractMessageRouter
implements MappingMessageRouterManagement {
    private volatile Map<String, String> channelMappings = new ConcurrentHashMap<String, String>();
    private volatile DestinationResolver<MessageChannel> channelResolver;
    private volatile String prefix;
    private volatile String suffix;
    private volatile boolean resolutionRequired = true;

    @Override
    @ManagedAttribute
    public void setChannelMappings(Map<String, String> channelMappings) {
        Assert.notNull(channelMappings, (String)"'channelMappings' must not be null");
        ConcurrentHashMap<String, String> newChannelMappings = new ConcurrentHashMap<String, String>();
        newChannelMappings.putAll(channelMappings);
        this.doSetChannelMappings(newChannelMappings);
    }

    public void setChannelResolver(DestinationResolver<MessageChannel> channelResolver) {
        Assert.notNull(channelResolver, (String)"'channelResolver' must not be null");
        this.channelResolver = channelResolver;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setResolutionRequired(boolean resolutionRequired) {
        this.resolutionRequired = resolutionRequired;
    }

    @Override
    @ManagedAttribute
    public Map<String, String> getChannelMappings() {
        return Collections.unmodifiableMap(this.channelMappings);
    }

    @Override
    @ManagedOperation
    public void setChannelMapping(String key, String channelName) {
        this.channelMappings.put(key, channelName);
    }

    @Override
    @ManagedOperation
    public void removeChannelMapping(String key) {
        this.channelMappings.remove(key);
    }

    @Override
    public void onInit() {
        try {
            super.onInit();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        BeanFactory beanFactory = this.getBeanFactory();
        if (this.channelResolver == null && beanFactory != null) {
            this.channelResolver = new BeanFactoryChannelResolver(beanFactory);
        }
    }

    protected abstract List<Object> getChannelKeys(Message<?> var1);

    @Override
    protected Collection<MessageChannel> determineTargetChannels(Message<?> message) {
        ArrayList<MessageChannel> channels = new ArrayList<MessageChannel>();
        List<Object> channelKeys = this.getChannelKeys(message);
        this.addToCollection(channels, channelKeys, message);
        return channels;
    }

    @Override
    @ManagedOperation
    public void replaceChannelMappings(Properties channelMappings) {
        Assert.notNull((Object)channelMappings, (String)"'channelMappings' must not be null");
        ConcurrentHashMap<String, String> newChannelMappings = new ConcurrentHashMap<String, String>();
        Set<String> keys = channelMappings.stringPropertyNames();
        for (String key : keys) {
            newChannelMappings.put(key.trim(), channelMappings.getProperty(key).trim());
        }
        this.doSetChannelMappings(newChannelMappings);
    }

    private void doSetChannelMappings(Map<String, String> newChannelMappings) {
        Map<String, String> oldChannelMappings = this.channelMappings;
        this.channelMappings = newChannelMappings;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Channel mappings:" + oldChannelMappings + " replaced with:" + newChannelMappings));
        }
    }

    private MessageChannel resolveChannelForName(String channelName, Message<?> message) {
        MessageChannel channel;
        block4: {
            if (this.channelResolver == null) {
                this.onInit();
            }
            Assert.state((this.channelResolver != null ? 1 : 0) != 0, (String)"unable to resolve channel names, no ChannelResolver available");
            channel = null;
            try {
                channel = (MessageChannel)this.channelResolver.resolveDestination(channelName);
            }
            catch (DestinationResolutionException e) {
                if (!this.resolutionRequired) break block4;
                throw new MessagingException(message, "failed to resolve channel name '" + channelName + "'", (Throwable)e);
            }
        }
        if (channel == null && this.resolutionRequired) {
            throw new MessagingException(message, "failed to resolve channel name '" + channelName + "'");
        }
        return channel;
    }

    private void addChannelFromString(Collection<MessageChannel> channels, String channelKey, Message<?> message) {
        MessageChannel channel;
        if (channelKey.indexOf(44) != -1) {
            for (String name : StringUtils.tokenizeToStringArray((String)channelKey, (String)",")) {
                this.addChannelFromString(channels, name, message);
            }
            return;
        }
        String channelName = channelKey;
        if (this.channelMappings.containsKey(channelKey)) {
            channelName = this.channelMappings.get(channelKey);
        }
        if (this.prefix != null) {
            channelName = this.prefix + channelName;
        }
        if (this.suffix != null) {
            channelName = channelName + this.suffix;
        }
        if ((channel = this.resolveChannelForName(channelName, message)) != null) {
            channels.add(channel);
        }
    }

    private void addToCollection(Collection<MessageChannel> channels, Collection<?> channelKeys, Message<?> message) {
        if (channelKeys == null) {
            return;
        }
        for (Object channelKey : channelKeys) {
            if (channelKey == null) continue;
            if (channelKey instanceof MessageChannel) {
                channels.add((MessageChannel)channelKey);
                continue;
            }
            if (channelKey instanceof MessageChannel[]) {
                channels.addAll(Arrays.asList((MessageChannel[])channelKey));
                continue;
            }
            if (channelKey instanceof String) {
                this.addChannelFromString(channels, (String)channelKey, message);
                continue;
            }
            if (channelKey instanceof String[]) {
                for (String indicatorName : (String[])channelKey) {
                    this.addChannelFromString(channels, indicatorName, message);
                }
                continue;
            }
            if (channelKey instanceof Collection) {
                this.addToCollection(channels, (Collection)channelKey, message);
                continue;
            }
            if (this.getRequiredConversionService().canConvert(channelKey.getClass(), String.class)) {
                this.addChannelFromString(channels, (String)this.getConversionService().convert(channelKey, String.class), message);
                continue;
            }
            throw new MessagingException("unsupported return type for router [" + channelKey.getClass() + "]");
        }
    }
}

