/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ManagedResource
public abstract class AbstractMessageRouter
extends AbstractMessageHandler {
    private volatile MessageChannel defaultOutputChannel;
    private volatile String defaultOutputChannelName;
    private volatile boolean ignoreSendFailures;
    private volatile boolean applySequence;
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();

    public void setDefaultOutputChannel(MessageChannel defaultOutputChannel) {
        this.defaultOutputChannel = defaultOutputChannel;
    }

    public void setDefaultOutputChannelName(String defaultOutputChannelName) {
        this.defaultOutputChannelName = defaultOutputChannelName;
    }

    public void setTimeout(long timeout) {
        this.messagingTemplate.setSendTimeout(timeout);
    }

    public void setIgnoreSendFailures(boolean ignoreSendFailures) {
        this.ignoreSendFailures = ignoreSendFailures;
    }

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    @Override
    public String getComponentType() {
        return "router";
    }

    protected MessagingTemplate getMessagingTemplate() {
        return this.messagingTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConversionService getRequiredConversionService() {
        if (this.getConversionService() == null) {
            AbstractMessageRouter abstractMessageRouter = this;
            synchronized (abstractMessageRouter) {
                if (this.getConversionService() == null) {
                    this.setConversionService((ConversionService)new DefaultConversionService());
                }
            }
        }
        return this.getConversionService();
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        if (this.getBeanFactory() != null) {
            this.messagingTemplate.setBeanFactory(this.getBeanFactory());
            if (StringUtils.hasText((String)this.defaultOutputChannelName)) {
                Assert.isNull((Object)this.defaultOutputChannel, (String)"'defaultOutputChannelName' and 'defaultOutputChannel' are mutually exclusive.");
                try {
                    this.defaultOutputChannel = (MessageChannel)this.getBeanFactory().getBean(this.defaultOutputChannelName, MessageChannel.class);
                }
                catch (BeansException e) {
                    throw new DestinationResolutionException("Failed to look up MessageChannel with name '" + this.defaultOutputChannelName + "' in the BeanFactory.");
                }
            }
        }
    }

    protected abstract Collection<MessageChannel> determineTargetChannels(Message<?> var1);

    @Override
    protected void handleMessageInternal(Message<?> message) {
        boolean sent = false;
        Collection<MessageChannel> results = this.determineTargetChannels(message);
        if (results != null) {
            int sequenceSize = results.size();
            int sequenceNumber = 1;
            for (MessageChannel channel : results) {
                Message<?> messageToSend;
                Message<?> message2 = messageToSend = !this.applySequence ? message : this.getMessageBuilderFactory().fromMessage(message).pushSequenceDetails(message.getHeaders().getId(), sequenceNumber++, sequenceSize).build();
                if (channel == null) continue;
                try {
                    this.messagingTemplate.send(channel, messageToSend);
                    sent = true;
                }
                catch (MessagingException e) {
                    if (!this.ignoreSendFailures) {
                        throw e;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)e);
                }
            }
        }
        if (!sent) {
            if (this.defaultOutputChannel != null) {
                this.messagingTemplate.send(this.defaultOutputChannel, message);
            } else {
                throw new MessageDeliveryException(message, "no channel resolved by router and no default output channel defined");
            }
        }
    }
}

