/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupMetadata;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractKeyValueMessageStore
extends AbstractMessageGroupStore
implements MessageStore {
    protected static final String MESSAGE_KEY_PREFIX = "MESSAGE_";
    protected static final String MESSAGE_GROUP_KEY_PREFIX = "MESSAGE_GROUP_";
    protected static final String CREATED_DATE = "CREATED_DATE";

    @Override
    public Message<?> getMessage(UUID id) {
        Message<?> message = this.getRawMessage(id);
        if (message != null) {
            return this.normalizeMessage(message);
        }
        return null;
    }

    @Override
    public <T> Message<T> addMessage(Message<T> message) {
        Assert.notNull(message, (String)"'message' must not be null");
        UUID messageId = message.getHeaders().getId();
        this.doStore(MESSAGE_KEY_PREFIX + messageId, message);
        return this.getRawMessage(messageId);
    }

    @Override
    public Message<?> removeMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Object message = this.doRemove(MESSAGE_KEY_PREFIX + id);
        if (message != null) {
            Assert.isInstanceOf(Message.class, (Object)message);
        }
        if (message != null) {
            return this.normalizeMessage((Message)message);
        }
        return null;
    }

    @Override
    @ManagedAttribute
    public long getMessageCount() {
        Collection<?> messageIds = this.doListKeys("MESSAGE_*");
        return messageIds != null ? (long)messageIds.size() : 0L;
    }

    @Override
    public MessageGroup getMessageGroup(Object groupId) {
        return this.buildMessageGroup(groupId, false);
    }

    @Override
    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(message, (String)"'message' must not be null");
        SimpleMessageGroup messageGroup = this.getSimpleMessageGroup(this.getMessageGroup(groupId));
        messageGroup.add(message);
        Message<?> enrichedMessage = this.enrichMessage(message);
        this.addMessage(enrichedMessage);
        SimpleMessageGroup rawGroup = this.buildMessageGroup(groupId, true);
        rawGroup.setLastModified(System.currentTimeMillis());
        rawGroup.add(enrichedMessage);
        this.doStore(MESSAGE_GROUP_KEY_PREFIX + groupId, new MessageGroupMetadata(rawGroup));
        return this.getMessageGroup(groupId);
    }

    @Override
    public MessageGroup removeMessageFromGroup(Object groupId, Message<?> messageToRemove) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messageToRemove, (String)"'messageToRemove' must not be null");
        SimpleMessageGroup rawGroup = this.buildMessageGroup(groupId, true);
        SimpleMessageGroup messageGroup = this.normalizeSimpleMessageGroup(rawGroup);
        for (Message<?> message : rawGroup.getMessages()) {
            if (!message.getHeaders().getId().equals(messageToRemove.getHeaders().getId())) continue;
            rawGroup.remove(message);
        }
        this.removeMessage(messageToRemove.getHeaders().getId());
        rawGroup.setLastModified(System.currentTimeMillis());
        this.doStore(MESSAGE_GROUP_KEY_PREFIX + groupId, new MessageGroupMetadata(rawGroup));
        messageGroup = this.getSimpleMessageGroup(this.getMessageGroup(groupId));
        return messageGroup;
    }

    @Override
    public void completeGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        SimpleMessageGroup messageGroup = this.buildMessageGroup(groupId, true);
        messageGroup.complete();
        messageGroup.setLastModified(System.currentTimeMillis());
        this.doStore(MESSAGE_GROUP_KEY_PREFIX + groupId, new MessageGroupMetadata(messageGroup));
    }

    @Override
    public void removeMessageGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Object mgm = this.doRemove(MESSAGE_GROUP_KEY_PREFIX + groupId);
        if (mgm != null) {
            Assert.isInstanceOf(MessageGroupMetadata.class, (Object)mgm);
            MessageGroupMetadata messageGroupMetadata = (MessageGroupMetadata)mgm;
            Iterator<UUID> messageIds = messageGroupMetadata.messageIdIterator();
            while (messageIds.hasNext()) {
                this.removeMessage(messageIds.next());
            }
        }
    }

    @Override
    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        SimpleMessageGroup messageGroup = this.buildMessageGroup(groupId, true);
        messageGroup.setLastReleasedMessageSequenceNumber(sequenceNumber);
        messageGroup.setLastModified(System.currentTimeMillis());
        this.doStore(MESSAGE_GROUP_KEY_PREFIX + groupId, new MessageGroupMetadata(messageGroup));
    }

    @Override
    public Message<?> pollMessageFromGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Object mgm = this.doRetrieve(MESSAGE_GROUP_KEY_PREFIX + groupId);
        if (mgm != null) {
            Assert.isInstanceOf(MessageGroupMetadata.class, (Object)mgm);
            MessageGroupMetadata messageGroupMetadata = (MessageGroupMetadata)mgm;
            UUID firstId = messageGroupMetadata.firstId();
            if (firstId != null) {
                messageGroupMetadata.remove(firstId);
                messageGroupMetadata.setLastModified(System.currentTimeMillis());
                this.doStore(MESSAGE_GROUP_KEY_PREFIX + groupId, messageGroupMetadata);
                return this.removeMessage(firstId);
            }
        }
        return null;
    }

    @Override
    public Iterator<MessageGroup> iterator() {
        Iterator<String> idIterator = this.normalizeKeys(this.doListKeys("MESSAGE_GROUP_*")).iterator();
        return new MessageGroupIterator(idIterator);
    }

    private Collection<String> normalizeKeys(Collection<String> keys) {
        HashSet<String> normalizedKeys = new HashSet<String>();
        for (String key : keys) {
            String strKey = key;
            if (strKey.startsWith(MESSAGE_GROUP_KEY_PREFIX)) {
                strKey = strKey.replace(MESSAGE_GROUP_KEY_PREFIX, "");
            } else if (strKey.startsWith(MESSAGE_KEY_PREFIX)) {
                strKey = strKey.replace(MESSAGE_KEY_PREFIX, "");
            }
            normalizedKeys.add(strKey);
        }
        return normalizedKeys;
    }

    @Override
    public int messageGroupSize(Object groupId) {
        Object mgm = this.doRetrieve(MESSAGE_GROUP_KEY_PREFIX + groupId);
        if (mgm != null) {
            Assert.isInstanceOf(MessageGroupMetadata.class, (Object)mgm);
            MessageGroupMetadata messageGroupMetadata = (MessageGroupMetadata)mgm;
            return messageGroupMetadata.size();
        }
        return 0;
    }

    protected abstract Object doRetrieve(Object var1);

    protected abstract void doStore(Object var1, Object var2);

    protected abstract Object doRemove(Object var1);

    protected abstract Collection<?> doListKeys(String var1);

    private Message<?> normalizeMessage(Message<?> message) {
        Message<?> normalizedMessage = this.getMessageBuilderFactory().fromMessage(message).removeHeader(CREATED_DATE).build();
        Map innerMap = (Map)new DirectFieldAccessor((Object)normalizedMessage.getHeaders()).getPropertyValue("headers");
        innerMap.put("id", message.getHeaders().getId());
        innerMap.put("timestamp", message.getHeaders().getTimestamp());
        return normalizedMessage;
    }

    private Message<?> enrichMessage(Message<?> message) {
        Message<?> enrichedMessage = this.getMessageBuilderFactory().fromMessage(message).setHeader(CREATED_DATE, System.currentTimeMillis()).build();
        Map innerMap = (Map)new DirectFieldAccessor((Object)enrichedMessage.getHeaders()).getPropertyValue("headers");
        innerMap.put("id", message.getHeaders().getId());
        innerMap.put("timestamp", message.getHeaders().getTimestamp());
        return enrichedMessage;
    }

    private SimpleMessageGroup buildMessageGroup(Object groupId, boolean raw) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Object mgm = this.doRetrieve(MESSAGE_GROUP_KEY_PREFIX + groupId);
        if (mgm != null) {
            Assert.isInstanceOf(MessageGroupMetadata.class, (Object)mgm);
            MessageGroupMetadata messageGroupMetadata = (MessageGroupMetadata)mgm;
            ArrayList messages = new ArrayList();
            Iterator<UUID> messageIds = messageGroupMetadata.messageIdIterator();
            while (messageIds.hasNext()) {
                if (raw) {
                    messages.add(this.getRawMessage(messageIds.next()));
                    continue;
                }
                messages.add(this.getMessage(messageIds.next()));
            }
            SimpleMessageGroup messageGroup = new SimpleMessageGroup(messages, groupId, messageGroupMetadata.getTimestamp(), messageGroupMetadata.isComplete());
            messageGroup.setLastModified(messageGroupMetadata.getLastModified());
            messageGroup.setLastReleasedMessageSequenceNumber(messageGroupMetadata.getLastReleasedMessageSequenceNumber());
            return messageGroup;
        }
        return new SimpleMessageGroup(groupId);
    }

    private SimpleMessageGroup getSimpleMessageGroup(MessageGroup messageGroup) {
        if (messageGroup instanceof SimpleMessageGroup) {
            return (SimpleMessageGroup)messageGroup;
        }
        return new SimpleMessageGroup(messageGroup);
    }

    private SimpleMessageGroup normalizeSimpleMessageGroup(SimpleMessageGroup messageGroup) {
        SimpleMessageGroup normalizedGroup = new SimpleMessageGroup(messageGroup.getGroupId());
        for (Message<?> message : messageGroup.getMessages()) {
            Message<?> normailizedMessage = this.normalizeMessage(message);
            normalizedGroup.add(normailizedMessage);
        }
        return normalizedGroup;
    }

    private Message<?> getRawMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Object message = this.doRetrieve(MESSAGE_KEY_PREFIX + id);
        return (Message)message;
    }

    private class MessageGroupIterator
    implements Iterator<MessageGroup> {
        private final Iterator<?> idIterator;

        private MessageGroupIterator(Iterator<?> idIterator) {
            this.idIterator = idIterator;
        }

        @Override
        public boolean hasNext() {
            return this.idIterator.hasNext();
        }

        @Override
        public MessageGroup next() {
            Object messageGroupId = this.idIterator.next();
            return AbstractKeyValueMessageStore.this.getMessageGroup(messageGroupId);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

