/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.store;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupMetadata;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;

@ManagedResource
public abstract class AbstractMessageGroupStore
implements MessageGroupStore,
Iterable<MessageGroup>,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Collection<MessageGroupStore.MessageGroupCallback> expiryCallbacks = new LinkedHashSet<MessageGroupStore.MessageGroupCallback>();
    private volatile boolean timeoutOnIdle;
    private volatile BeanFactory beanFactory;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();

    public final void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(this.beanFactory);
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        return this.messageBuilderFactory;
    }

    public void setExpiryCallbacks(Collection<MessageGroupStore.MessageGroupCallback> expiryCallbacks) {
        for (MessageGroupStore.MessageGroupCallback callback : expiryCallbacks) {
            this.registerMessageGroupExpiryCallback(callback);
        }
    }

    public boolean isTimeoutOnIdle() {
        return this.timeoutOnIdle;
    }

    public void setTimeoutOnIdle(boolean timeoutOnIdle) {
        this.timeoutOnIdle = timeoutOnIdle;
    }

    @Override
    public void registerMessageGroupExpiryCallback(MessageGroupStore.MessageGroupCallback callback) {
        this.expiryCallbacks.add(callback);
    }

    @Override
    public int expireMessageGroups(long timeout) {
        int count = 0;
        long threshold = System.currentTimeMillis() - timeout;
        for (MessageGroup group : this) {
            long timestamp = group.getTimestamp();
            if (this.isTimeoutOnIdle() && group.getLastModified() > 0L) {
                timestamp = group.getLastModified();
            }
            if (timestamp > threshold) continue;
            ++count;
            this.expire(this.copy(group));
        }
        return count;
    }

    protected MessageGroup copy(MessageGroup group) {
        return group;
    }

    @Override
    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        int count = 0;
        for (MessageGroup group : this) {
            count += group.size();
        }
        return count;
    }

    @Override
    @ManagedAttribute
    public int getMessageGroupCount() {
        int count = 0;
        for (MessageGroup group : this) {
            ++count;
        }
        return count;
    }

    @Override
    public MessageGroupMetadata getGroupMetadata(Object groupId) {
        throw new UnsupportedOperationException("Not yet implemented for this store");
    }

    @Override
    public Message<?> getOneMessageFromGroup(Object groupId) {
        throw new UnsupportedOperationException("Not yet implemented for this store");
    }

    private void expire(MessageGroup group) {
        RuntimeException exception = null;
        for (MessageGroupStore.MessageGroupCallback callback : this.expiryCallbacks) {
            try {
                callback.execute(this, group);
            }
            catch (RuntimeException e) {
                if (exception == null) {
                    exception = e;
                }
                this.logger.error((Object)"Exception in expiry callback", (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

