/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.integration.IntegrationMessageHeaderAccessor;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;

public final class MessageBuilder<T>
extends AbstractIntegrationMessageBuilder<T> {
    private final T payload;
    private final IntegrationMessageHeaderAccessor headerAccessor;
    private final Message<T> originalMessage;
    private volatile boolean modified;

    private MessageBuilder(T payload, Message<T> originalMessage) {
        Assert.notNull(payload, (String)"payload must not be null");
        this.payload = payload;
        this.originalMessage = originalMessage;
        this.headerAccessor = new IntegrationMessageHeaderAccessor(originalMessage);
        if (originalMessage != null) {
            this.modified = !this.payload.equals(originalMessage.getPayload());
        }
    }

    public static <T> MessageBuilder<T> fromMessage(Message<T> message) {
        Assert.notNull(message, (String)"message must not be null");
        MessageBuilder<Object> builder = new MessageBuilder<Object>(message.getPayload(), message);
        return builder;
    }

    public static <T> MessageBuilder<T> withPayload(T payload) {
        MessageBuilder<T> builder = new MessageBuilder<T>(payload, null);
        return builder;
    }

    @Override
    public MessageBuilder<T> setHeader(String headerName, Object headerValue) {
        this.headerAccessor.setHeader(headerName, headerValue);
        return this;
    }

    @Override
    public MessageBuilder<T> setHeaderIfAbsent(String headerName, Object headerValue) {
        this.headerAccessor.setHeaderIfAbsent(headerName, headerValue);
        return this;
    }

    @Override
    public MessageBuilder<T> removeHeaders(String ... headerPatterns) {
        this.headerAccessor.removeHeaders(headerPatterns);
        return this;
    }

    @Override
    public MessageBuilder<T> removeHeader(String headerName) {
        this.headerAccessor.removeHeader(headerName);
        return this;
    }

    @Override
    public MessageBuilder<T> copyHeaders(Map<String, ?> headersToCopy) {
        this.headerAccessor.copyHeaders(headersToCopy);
        return this;
    }

    @Override
    public MessageBuilder<T> copyHeadersIfAbsent(Map<String, ?> headersToCopy) {
        this.headerAccessor.copyHeadersIfAbsent(headersToCopy);
        return this;
    }

    @Override
    protected List<List<Object>> getSequenceDetails() {
        return (List)this.headerAccessor.getHeader("sequenceDetails");
    }

    @Override
    protected Object getCorrelationId() {
        return this.headerAccessor.getCorrelationId();
    }

    @Override
    protected Object getSequenceNumber() {
        return this.headerAccessor.getSequenceNumber();
    }

    @Override
    protected Object getSequenceSize() {
        return this.headerAccessor.getSequenceSize();
    }

    @Override
    public MessageBuilder<T> pushSequenceDetails(Object correlationId, int sequenceNumber, int sequenceSize) {
        super.pushSequenceDetails(correlationId, sequenceNumber, sequenceSize);
        return this;
    }

    @Override
    public MessageBuilder<T> popSequenceDetails() {
        super.popSequenceDetails();
        return this;
    }

    @Override
    public MessageBuilder<T> setExpirationDate(Long expirationDate) {
        super.setExpirationDate(expirationDate);
        return this;
    }

    @Override
    public MessageBuilder<T> setExpirationDate(Date expirationDate) {
        super.setExpirationDate(expirationDate);
        return this;
    }

    @Override
    public MessageBuilder<T> setCorrelationId(Object correlationId) {
        super.setCorrelationId(correlationId);
        return this;
    }

    @Override
    public MessageBuilder<T> setReplyChannel(MessageChannel replyChannel) {
        super.setReplyChannel(replyChannel);
        return this;
    }

    @Override
    public MessageBuilder<T> setReplyChannelName(String replyChannelName) {
        super.setReplyChannelName(replyChannelName);
        return this;
    }

    @Override
    public MessageBuilder<T> setErrorChannel(MessageChannel errorChannel) {
        super.setErrorChannel(errorChannel);
        return this;
    }

    @Override
    public MessageBuilder<T> setErrorChannelName(String errorChannelName) {
        super.setErrorChannelName(errorChannelName);
        return this;
    }

    @Override
    public MessageBuilder<T> setSequenceNumber(Integer sequenceNumber) {
        super.setSequenceNumber(sequenceNumber);
        return this;
    }

    @Override
    public MessageBuilder<T> setSequenceSize(Integer sequenceSize) {
        super.setSequenceSize(sequenceSize);
        return this;
    }

    @Override
    public MessageBuilder<T> setPriority(Integer priority) {
        super.setPriority(priority);
        return this;
    }

    @Override
    public Message<T> build() {
        if (!this.modified && !this.headerAccessor.isModified() && this.originalMessage != null) {
            return this.originalMessage;
        }
        if (this.payload instanceof Throwable) {
            return new ErrorMessage((Throwable)this.payload, this.headerAccessor.toMap());
        }
        return new GenericMessage(this.payload, this.headerAccessor.toMap());
    }
}

