/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public class MapMessageConverter
implements MessageConverter,
BeanFactoryAware {
    private volatile String[] headerNames;
    private volatile boolean filterHeadersInToMessage;
    private volatile BeanFactory beanFactory;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();

    public final void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(this.beanFactory);
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        return this.messageBuilderFactory;
    }

    public void setHeaderNames(String ... headerNames) {
        this.headerNames = headerNames;
    }

    public void setFilterHeadersInToMessage(boolean filterHeadersInToMessage) {
        this.filterHeadersInToMessage = filterHeadersInToMessage;
    }

    public Message<?> toMessage(Object object, MessageHeaders messageHeaders) {
        Assert.isInstanceOf(Map.class, (Object)object, (String)"This converter expects a Map");
        Map map = (Map)object;
        Object payload = map.get("payload");
        Assert.notNull(payload, (String)"'payload' entry cannot be null");
        AbstractIntegrationMessageBuilder messageBuilder = this.messageBuilderFactory.withPayload(payload);
        Map headers = (Map)map.get("headers");
        if (headers != null) {
            if (this.filterHeadersInToMessage) {
                headers.keySet().retainAll(Arrays.asList(this.headerNames));
            }
            messageBuilder.copyHeaders(headers);
        }
        Message convertedMessage = messageBuilder.build();
        return convertedMessage;
    }

    public Object fromMessage(Message<?> message, Class<?> clazz) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("payload", message.getPayload());
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (String headerName : this.headerNames) {
            Object header = message.getHeaders().get((Object)headerName);
            if (header == null) continue;
            headers.put(headerName, header);
        }
        map.put("headers", headers);
        return map;
    }
}

