/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.converter;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;

public class SimpleMessageConverter
implements MessageConverter,
BeanFactoryAware {
    private volatile InboundMessageMapper inboundMessageMapper;
    private volatile OutboundMessageMapper outboundMessageMapper;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();

    public SimpleMessageConverter() {
        this(null, null);
    }

    public SimpleMessageConverter(InboundMessageMapper<?> inboundMessageMapper) {
        this(inboundMessageMapper, inboundMessageMapper instanceof OutboundMessageMapper ? (OutboundMessageMapper)((Object)inboundMessageMapper) : null);
    }

    public SimpleMessageConverter(OutboundMessageMapper<?> outboundMessageMapper) {
        this(outboundMessageMapper instanceof InboundMessageMapper ? (InboundMessageMapper)((Object)outboundMessageMapper) : null, outboundMessageMapper);
    }

    public SimpleMessageConverter(InboundMessageMapper<?> inboundMessageMapper, OutboundMessageMapper<?> outboundMessageMapper) {
        this.setInboundMessageMapper(inboundMessageMapper);
        this.setOutboundMessageMapper(outboundMessageMapper);
    }

    public void setInboundMessageMapper(InboundMessageMapper<?> inboundMessageMapper) {
        this.inboundMessageMapper = inboundMessageMapper != null ? inboundMessageMapper : new DefaultInboundMessageMapper();
    }

    public void setOutboundMessageMapper(OutboundMessageMapper<?> outboundMessageMapper) {
        this.outboundMessageMapper = outboundMessageMapper != null ? outboundMessageMapper : new DefaultOutboundMessageMapper();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(beanFactory);
    }

    public Message<?> toMessage(Object object, MessageHeaders headers) {
        try {
            return this.inboundMessageMapper.toMessage(object);
        }
        catch (Exception e) {
            throw new MessageConversionException("failed to convert object to Message", (Throwable)e);
        }
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        try {
            return this.outboundMessageMapper.fromMessage(message);
        }
        catch (Exception e) {
            throw new MessageConversionException(message, "failed to convert Message to object", (Throwable)e);
        }
    }

    private class DefaultOutboundMessageMapper
    implements OutboundMessageMapper<Object> {
        private DefaultOutboundMessageMapper() {
        }

        @Override
        public Object fromMessage(Message<?> message) throws Exception {
            return message != null ? message.getPayload() : null;
        }
    }

    private class DefaultInboundMessageMapper
    implements InboundMessageMapper<Object> {
        private DefaultInboundMessageMapper() {
        }

        @Override
        public Message<?> toMessage(Object object) throws Exception {
            if (object == null) {
                return null;
            }
            if (object instanceof Message) {
                return (Message)object;
            }
            return SimpleMessageConverter.this.messageBuilderFactory.withPayload(object).build();
        }
    }
}

