/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.json;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import org.springframework.integration.support.json.AbstractJacksonJsonObjectMapper;
import org.springframework.util.Assert;

@Deprecated
public class JacksonJsonObjectMapper
extends AbstractJacksonJsonObjectMapper<JsonNode, JsonParser, JavaType> {
    private final ObjectMapper objectMapper;

    public JacksonJsonObjectMapper() {
        this.objectMapper = new ObjectMapper();
    }

    public JacksonJsonObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    @Override
    public String toJson(Object value) throws Exception {
        return this.objectMapper.writeValueAsString(value);
    }

    @Override
    public void toJson(Object value, Writer writer) throws Exception {
        this.objectMapper.writeValue(writer, value);
    }

    @Override
    public JsonNode toJsonNode(Object value) throws Exception {
        return this.objectMapper.valueToTree(value);
    }

    @Override
    public <T> T fromJson(JsonParser parser, Type valueType) throws Exception {
        return (T)this.objectMapper.readValue(parser, this.constructType(valueType));
    }

    @Override
    protected <T> T fromJson(Object json, JavaType type) throws Exception {
        if (json instanceof String) {
            return (T)this.objectMapper.readValue((String)json, type);
        }
        if (json instanceof byte[]) {
            return (T)this.objectMapper.readValue((byte[])json, type);
        }
        if (json instanceof File) {
            return (T)this.objectMapper.readValue((File)json, type);
        }
        if (json instanceof URL) {
            return (T)this.objectMapper.readValue((URL)json, type);
        }
        if (json instanceof InputStream) {
            return (T)this.objectMapper.readValue((InputStream)json, type);
        }
        if (json instanceof Reader) {
            return (T)this.objectMapper.readValue((Reader)json, type);
        }
        throw new IllegalArgumentException("'json' argument must be an instance of: " + supportedJsonTypes);
    }

    @Override
    public void populateJavaTypes(Map<String, Object> map, Class<?> sourceClass) {
        JavaType javaType = this.constructType(sourceClass);
        map.put("json__TypeId__", javaType.getRawClass());
        if (javaType.isContainerType() && !javaType.isArrayType()) {
            map.put("json__ContentTypeId__", javaType.getContentType().getRawClass());
        }
        if (javaType.getKeyType() != null) {
            map.put("json__KeyTypeId__", javaType.getKeyType().getRawClass());
        }
    }

    @Override
    protected JavaType constructType(Type type) {
        return this.objectMapper.constructType(type);
    }

    @Override
    protected JavaType extractJavaType(Map<String, Object> javaTypes) throws Exception {
        JavaType classType = (JavaType)this.createJavaType(javaTypes, "json__TypeId__");
        if (!classType.isContainerType() || classType.isArrayType()) {
            return classType;
        }
        JavaType contentClassType = (JavaType)this.createJavaType(javaTypes, "json__ContentTypeId__");
        if (classType.getKeyType() == null) {
            return this.objectMapper.getTypeFactory().constructCollectionType(classType.getRawClass(), contentClassType);
        }
        JavaType keyClassType = (JavaType)this.createJavaType(javaTypes, "json__KeyTypeId__");
        return this.objectMapper.getTypeFactory().constructMapType(classType.getRawClass(), keyClassType, contentClassType);
    }
}

