/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.Lifecycle;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.IntegrationEvaluationContextAware;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.transformer.support.HeaderValueMessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ContentEnricher
extends AbstractReplyProducingMessageHandler
implements Lifecycle,
IntegrationEvaluationContextAware {
    private volatile Map<Expression, Expression> propertyExpressions = new HashMap<Expression, Expression>();
    private volatile Map<String, HeaderValueMessageProcessor<?>> headerExpressions = new HashMap();
    private final SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private EvaluationContext sourceEvaluationContext;
    private EvaluationContext targetEvaluationContext;
    private volatile boolean shouldClonePayload = false;
    private Expression requestPayloadExpression;
    private volatile MessageChannel requestChannel;
    private volatile String requestChannelName;
    private volatile MessageChannel replyChannel;
    private volatile String replyChannelName;
    private volatile Gateway gateway = null;
    private volatile Long requestTimeout;
    private volatile Long replyTimeout;

    public void setPropertyExpressions(Map<String, Expression> propertyExpressions) {
        Assert.notEmpty(propertyExpressions, (String)"propertyExpressions must not be empty");
        Assert.noNullElements((Object[])propertyExpressions.keySet().toArray(), (String)"propertyExpressions keys must not be empty");
        Assert.noNullElements((Object[])propertyExpressions.values().toArray(), (String)"propertyExpressions values must not be empty");
        HashMap<Expression, Expression> localMap = new HashMap<Expression, Expression>(propertyExpressions.size());
        for (Map.Entry<String, Expression> entry : propertyExpressions.entrySet()) {
            String key = entry.getKey();
            Expression value = entry.getValue();
            localMap.put(this.parser.parseExpression(key), value);
        }
        this.propertyExpressions = localMap;
    }

    public void setHeaderExpressions(Map<String, HeaderValueMessageProcessor<?>> headerExpressions) {
        Assert.notEmpty(headerExpressions, (String)"headerExpressions must not be empty");
        Assert.noNullElements((Object[])headerExpressions.keySet().toArray(), (String)"headerExpressions keys must not be empty");
        Assert.noNullElements((Object[])headerExpressions.values().toArray(), (String)"headerExpressions values must not be empty");
        this.headerExpressions = new HashMap(headerExpressions);
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        this.requestChannel = requestChannel;
    }

    public void setRequestChannelName(String requestChannelName) {
        this.requestChannelName = requestChannelName;
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.replyChannel = replyChannel;
    }

    public void setReplyChannelName(String replyChannelName) {
        this.replyChannelName = replyChannelName;
    }

    public void setRequestTimeout(Long requestTimeout) {
        Assert.notNull((Object)requestTimeout, (String)"requestTimeout must not be null");
        this.requestTimeout = requestTimeout;
    }

    public void setReplyTimeout(Long replyTimeout) {
        Assert.notNull((Object)replyTimeout, (String)"replyTimeout must not be null");
        this.replyTimeout = replyTimeout;
    }

    public void setRequestPayloadExpression(Expression requestPayloadExpression) {
        this.requestPayloadExpression = requestPayloadExpression;
    }

    public void setShouldClonePayload(boolean shouldClonePayload) {
        this.shouldClonePayload = shouldClonePayload;
    }

    @Override
    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.sourceEvaluationContext = evaluationContext;
    }

    @Override
    public String getComponentType() {
        return "enricher";
    }

    @Override
    protected void doInit() {
        if (StringUtils.hasText((String)this.requestChannelName)) {
            Assert.isNull((Object)this.requestChannel, (String)"'requestChannelName' and 'requestChannel' are mutually exclusive.");
            this.requestChannel = (MessageChannel)this.getBeanFactory().getBean(this.requestChannelName, MessageChannel.class);
        }
        if (StringUtils.hasText((String)this.replyChannelName)) {
            Assert.isNull((Object)this.replyChannel, (String)"'replyChannelName' and 'replyChannel' are mutually exclusive.");
            this.replyChannel = (MessageChannel)this.getBeanFactory().getBean(this.replyChannelName, MessageChannel.class);
        }
        if (this.replyChannel != null) {
            Assert.notNull((Object)this.requestChannel, (String)"If the replyChannel is set, then the requestChannel must not be null");
        }
        if (this.requestChannel != null) {
            this.gateway = new Gateway();
            this.gateway.setRequestChannel(this.requestChannel);
            if (this.requestTimeout != null) {
                this.gateway.setRequestTimeout(this.requestTimeout);
            }
            if (this.replyTimeout != null) {
                this.gateway.setReplyTimeout(this.replyTimeout);
            }
            if (this.replyChannel != null) {
                this.gateway.setReplyChannel(this.replyChannel);
            }
            if (this.getBeanFactory() != null) {
                this.gateway.setBeanFactory(this.getBeanFactory());
            }
            this.gateway.afterPropertiesSet();
        }
        if (this.sourceEvaluationContext == null) {
            this.sourceEvaluationContext = ExpressionUtils.createStandardEvaluationContext(this.getBeanFactory());
        }
        StandardEvaluationContext targetContext = ExpressionUtils.createStandardEvaluationContext(this.getBeanFactory());
        targetContext.setBeanResolver(null);
        this.targetEvaluationContext = targetContext;
        if (this.getBeanFactory() != null) {
            for (HeaderValueMessageProcessor<?> headerValueMessageProcessor : this.headerExpressions.values()) {
                if (!(headerValueMessageProcessor instanceof BeanFactoryAware)) continue;
                ((BeanFactoryAware)headerValueMessageProcessor).setBeanFactory(this.getBeanFactory());
            }
        }
    }

    @Override
    protected Object handleRequestMessage(Message<?> requestMessage) {
        Message<?> replyMessage;
        Object actualRequestMessage;
        Object targetPayload;
        Object requestPayload = requestMessage.getPayload();
        if (requestPayload instanceof Cloneable && this.shouldClonePayload) {
            try {
                Method cloneMethod = requestPayload.getClass().getMethod("clone", new Class[0]);
                targetPayload = ReflectionUtils.invokeMethod((Method)cloneMethod, (Object)requestPayload);
            }
            catch (Exception e) {
                throw new MessageHandlingException(requestMessage, "Failed to clone payload object", (Throwable)e);
            }
        } else {
            targetPayload = requestPayload;
        }
        if (this.requestPayloadExpression == null) {
            actualRequestMessage = requestMessage;
        } else {
            Object requestMessagePayload = this.requestPayloadExpression.getValue(this.sourceEvaluationContext, requestMessage);
            actualRequestMessage = this.getMessageBuilderFactory().withPayload(requestMessagePayload).copyHeaders((Map<String, ?>)requestMessage.getHeaders()).build();
        }
        if (this.gateway == null) {
            replyMessage = actualRequestMessage;
        } else {
            replyMessage = this.gateway.sendAndReceiveMessage(actualRequestMessage);
            if (replyMessage == null) {
                return replyMessage;
            }
        }
        for (Map.Entry<Expression, Expression> entry : this.propertyExpressions.entrySet()) {
            Expression propertyExpression = entry.getKey();
            Expression valueExpression = entry.getValue();
            Object value = valueExpression.getValue(this.sourceEvaluationContext, replyMessage);
            propertyExpression.setValue(this.targetEvaluationContext, targetPayload, value);
        }
        if (this.headerExpressions.isEmpty()) {
            return targetPayload;
        }
        HashMap targetHeaders = new HashMap(this.headerExpressions.size());
        for (Map.Entry<String, HeaderValueMessageProcessor<?>> entry : this.headerExpressions.entrySet()) {
            String header = entry.getKey();
            HeaderValueMessageProcessor<?> valueProcessor = entry.getValue();
            Boolean overwrite = valueProcessor.isOverwrite();
            overwrite = overwrite != null ? overwrite : true;
            if (!overwrite.booleanValue() && requestMessage.getHeaders().containsKey((Object)header)) continue;
            Object value = valueProcessor.processMessage(replyMessage);
            targetHeaders.put(header, value);
        }
        return this.getMessageBuilderFactory().withPayload(targetPayload).copyHeaders(targetHeaders).build();
    }

    public void start() {
        if (this.gateway != null) {
            this.gateway.start();
        }
    }

    public void stop() {
        if (this.gateway != null) {
            this.gateway.stop();
        }
    }

    public boolean isRunning() {
        if (this.gateway != null) {
            return this.gateway.isRunning();
        }
        return true;
    }

    private static final class Gateway
    extends MessagingGatewaySupport {
        private Gateway() {
        }

        @Override
        protected Message<?> sendAndReceiveMessage(Object object) {
            return super.sendAndReceiveMessage(object);
        }

        @Override
        public String getComponentType() {
            return "enricher$gateway";
        }
    }
}

