/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodFilter;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.annotation.Header;
import org.springframework.integration.annotation.Headers;
import org.springframework.integration.annotation.Payload;
import org.springframework.integration.annotation.Payloads;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.integration.util.AnnotatedMethodFilter;
import org.springframework.integration.util.ClassUtils;
import org.springframework.integration.util.FixedMethodFilter;
import org.springframework.integration.util.UniqueMethodFilter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MessagingMethodInvokerHelper<T>
extends AbstractExpressionEvaluator {
    private static final String CANDIDATE_METHODS = "CANDIDATE_METHODS";
    private static final String CANDIDATE_MESSAGE_METHODS = "CANDIDATE_MESSAGE_METHODS";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Object targetObject;
    private volatile String displayString;
    private volatile boolean requiresReply;
    private final Map<Class<?>, HandlerMethod> handlerMethods;
    private final Map<Class<?>, HandlerMethod> handlerMessageMethods;
    private final LinkedList<Map<Class<?>, HandlerMethod>> handlerMethodsList;
    private final HandlerMethod handlerMethod;
    private final Class<?> expectedType;
    private final boolean canProcessMessageList;

    public MessagingMethodInvokerHelper(Object targetObject, Method method, Class<?> expectedType, boolean canProcessMessageList) {
        this(targetObject, null, method, expectedType, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, Method method, boolean canProcessMessageList) {
        this(targetObject, method, null, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, String methodName, Class<?> expectedType, boolean canProcessMessageList) {
        this(targetObject, null, methodName, expectedType, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, String methodName, boolean canProcessMessageList) {
        this(targetObject, methodName, null, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, boolean canProcessMessageList) {
        this(targetObject, annotationType, null, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, Class<?> expectedType, boolean canProcessMessageList) {
        this(targetObject, annotationType, (String)null, expectedType, canProcessMessageList);
    }

    public T process(Message<?> message) throws Exception {
        ParametersWrapper parameters = new ParametersWrapper(message);
        return this.processInternal(parameters);
    }

    public T process(Collection<Message<?>> messages, Map<String, ?> headers) throws Exception {
        ParametersWrapper parameters = new ParametersWrapper(messages, headers);
        return this.processInternal(parameters);
    }

    public String toString() {
        return this.displayString;
    }

    private MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, Method method, Class<?> expectedType, boolean canProcessMessageList) {
        this.canProcessMessageList = canProcessMessageList;
        Assert.notNull((Object)method, (String)"method must not be null");
        this.expectedType = expectedType;
        boolean bl = this.requiresReply = expectedType != null;
        if (expectedType != null) {
            Assert.isTrue((method.getReturnType() != Void.class && method.getReturnType() != Void.TYPE ? 1 : 0) != 0, (String)"method must have a return type");
        }
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        this.targetObject = targetObject;
        try {
            this.handlerMethod = new HandlerMethod(method, canProcessMessageList);
        }
        catch (IneligibleMethodException e) {
            throw new IllegalArgumentException(e);
        }
        this.handlerMethods = null;
        this.handlerMessageMethods = null;
        this.handlerMethodsList = null;
        this.prepareEvaluationContext(this.getEvaluationContext(false), method, annotationType);
        this.setDisplayString(targetObject, method);
    }

    private MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, String methodName, Class<?> expectedType, boolean canProcessMessageList) {
        this.canProcessMessageList = canProcessMessageList;
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        this.expectedType = expectedType;
        this.targetObject = targetObject;
        this.requiresReply = expectedType != null;
        Map<String, Map<Class<?>, HandlerMethod>> handlerMethodsForTarget = this.findHandlerMethodsForTarget(targetObject, annotationType, methodName, this.requiresReply);
        Map<Class<?>, HandlerMethod> handlerMethods = handlerMethodsForTarget.get(CANDIDATE_METHODS);
        Map<Class<?>, HandlerMethod> handlerMessageMethods = handlerMethodsForTarget.get(CANDIDATE_MESSAGE_METHODS);
        if (handlerMethods.size() == 1 && handlerMessageMethods.isEmpty() || handlerMessageMethods.size() == 1 && handlerMethods.isEmpty()) {
            this.handlerMethod = handlerMethods.size() == 1 ? handlerMethods.values().iterator().next() : handlerMessageMethods.values().iterator().next();
            this.handlerMethods = null;
            this.handlerMessageMethods = null;
            this.handlerMethodsList = null;
        } else {
            this.handlerMethod = null;
            this.handlerMethods = handlerMethods;
            this.handlerMessageMethods = handlerMessageMethods;
            this.handlerMethodsList = new LinkedList();
            this.handlerMethodsList.add(this.handlerMethods);
            this.handlerMethodsList.add(this.handlerMessageMethods);
        }
        this.prepareEvaluationContext(this.getEvaluationContext(false), methodName, annotationType);
        this.setDisplayString(targetObject, methodName);
    }

    private void setDisplayString(Object targetObject, Object targetMethod) {
        StringBuilder sb = new StringBuilder(targetObject.getClass().getName());
        if (targetMethod instanceof Method) {
            sb.append("." + ((Method)targetMethod).getName());
        } else if (targetMethod instanceof String) {
            sb.append("." + targetMethod);
        }
        this.displayString = sb.toString() + "]";
    }

    private void prepareEvaluationContext(StandardEvaluationContext context, Object method, Class<? extends Annotation> annotationType) {
        Class targetType = AopUtils.getTargetClass((Object)this.targetObject);
        if (method instanceof Method) {
            context.registerMethodFilter(targetType, (MethodFilter)new FixedMethodFilter((Method)method));
            if (this.expectedType != null) {
                Assert.state((boolean)context.getTypeConverter().canConvert(TypeDescriptor.valueOf(((Method)method).getReturnType()), TypeDescriptor.valueOf(this.expectedType)), (String)("Cannot convert to expected type (" + this.expectedType + ") from " + method));
            }
        } else if (method == null || method instanceof String) {
            AnnotatedMethodFilter filter = new AnnotatedMethodFilter(annotationType, (String)method, this.requiresReply);
            Assert.state((boolean)this.canReturnExpectedType(filter, targetType, context.getTypeConverter()), (String)("Cannot convert to expected type (" + this.expectedType + ") from " + method));
            context.registerMethodFilter(targetType, (MethodFilter)filter);
        }
        context.setVariable("target", this.targetObject);
    }

    private boolean canReturnExpectedType(AnnotatedMethodFilter filter, Class<?> targetType, TypeConverter typeConverter) {
        if (this.expectedType == null) {
            return true;
        }
        List<Method> methods = filter.filter(Arrays.asList(ReflectionUtils.getAllDeclaredMethods(targetType)));
        for (Method method : methods) {
            if (!typeConverter.canConvert(TypeDescriptor.valueOf(method.getReturnType()), TypeDescriptor.valueOf(this.expectedType))) continue;
            return true;
        }
        return false;
    }

    private T processInternal(ParametersWrapper parameters) throws Exception {
        HandlerMethod candidate = this.findHandlerMethodForParameters(parameters);
        Assert.notNull((Object)candidate, (String)"No candidate methods found for messages.");
        Expression expression = candidate.getExpression();
        Class<?> expectedType = this.expectedType != null ? this.expectedType : candidate.method.getReturnType();
        try {
            Object result = this.evaluateExpression(expression, (Object)parameters, expectedType);
            if (this.requiresReply) {
                Assert.notNull(result, (String)"Expression evaluation result was null, but this processor requires a reply.");
            }
            return (T)result;
        }
        catch (Exception e) {
            Throwable evaluationException = e;
            if ((e instanceof EvaluationException || e instanceof MessageHandlingException) && e.getCause() != null) {
                evaluationException = e.getCause();
            }
            if (evaluationException instanceof Exception) {
                throw evaluationException;
            }
            throw new IllegalStateException("Cannot process message", evaluationException);
        }
    }

    private Map<String, Map<Class<?>, HandlerMethod>> findHandlerMethodsForTarget(Object targetObject, final Class<? extends Annotation> annotationType, final String methodName, final boolean requiresReply) {
        HashMap handlerMethods = new HashMap();
        final HashMap candidateMethods = new HashMap();
        final HashMap candidateMessageMethods = new HashMap();
        final HashMap fallbackMethods = new HashMap();
        final HashMap fallbackMessageMethods = new HashMap();
        final AtomicReference ambiguousFallbackType = new AtomicReference();
        final AtomicReference ambiguousFallbackMessageGenericType = new AtomicReference();
        Class<?> targetClass = this.getTargetClass(targetObject);
        UniqueMethodFilter methodFilter = new UniqueMethodFilter(targetClass);
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                boolean matchesAnnotation = false;
                if (method.isBridge()) {
                    return;
                }
                if (MessagingMethodInvokerHelper.isMethodDefinedOnObjectClass(method)) {
                    return;
                }
                if (method.getDeclaringClass().equals(Proxy.class)) {
                    return;
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    return;
                }
                if (requiresReply && Void.TYPE.equals(method.getReturnType())) {
                    return;
                }
                if (methodName != null && !methodName.equals(method.getName())) {
                    return;
                }
                if (annotationType != null && AnnotationUtils.findAnnotation((Method)method, (Class)annotationType) != null) {
                    matchesAnnotation = true;
                }
                HandlerMethod handlerMethod = null;
                try {
                    handlerMethod = new HandlerMethod(method, MessagingMethodInvokerHelper.this.canProcessMessageList);
                }
                catch (IneligibleMethodException e) {
                    if (MessagingMethodInvokerHelper.this.logger.isDebugEnabled()) {
                        MessagingMethodInvokerHelper.this.logger.debug((Object)("Method [" + method + "] is not eligible for Message handling " + e.getMessage() + "."));
                    }
                    return;
                }
                catch (Exception e) {
                    if (MessagingMethodInvokerHelper.this.logger.isDebugEnabled()) {
                        MessagingMethodInvokerHelper.this.logger.debug((Object)("Method [" + method + "] is not eligible for Message handling."), (Throwable)e);
                    }
                    return;
                }
                Class<?> targetParameterType = handlerMethod.getTargetParameterType();
                if (matchesAnnotation || annotationType == null) {
                    if (handlerMethod.isMessageMethod()) {
                        if (candidateMessageMethods.containsKey(targetParameterType)) {
                            throw new IllegalArgumentException("Found more than one method match for type [Message<" + targetParameterType + ">]");
                        }
                        candidateMessageMethods.put(targetParameterType, handlerMethod);
                    } else {
                        if (candidateMethods.containsKey(targetParameterType)) {
                            String exceptionMessage = "Found more than one method match for ";
                            exceptionMessage = Void.class.equals(targetParameterType) ? exceptionMessage + "empty parameter for 'payload'" : exceptionMessage + "type [" + targetParameterType + "]";
                            throw new IllegalArgumentException(exceptionMessage);
                        }
                        candidateMethods.put(targetParameterType, handlerMethod);
                    }
                } else if (handlerMethod.isMessageMethod()) {
                    if (fallbackMessageMethods.containsKey(targetParameterType)) {
                        ambiguousFallbackMessageGenericType.compareAndSet(null, targetParameterType);
                    }
                    fallbackMessageMethods.put(targetParameterType, handlerMethod);
                } else {
                    if (fallbackMethods.containsKey(targetParameterType)) {
                        ambiguousFallbackType.compareAndSet(null, targetParameterType);
                    }
                    fallbackMethods.put(targetParameterType, handlerMethod);
                }
            }
        }, (ReflectionUtils.MethodFilter)methodFilter);
        if (!candidateMethods.isEmpty() || !candidateMessageMethods.isEmpty()) {
            handlerMethods.put(CANDIDATE_METHODS, candidateMethods);
            handlerMethods.put(CANDIDATE_MESSAGE_METHODS, candidateMessageMethods);
            return handlerMethods;
        }
        if ((ambiguousFallbackType.get() != null || ambiguousFallbackMessageGenericType.get() != null) && ServiceActivator.class.equals(annotationType)) {
            Class[] allInterfaces;
            ArrayList<Method> frameworkMethods = new ArrayList<Method>();
            for (Class iface : allInterfaces = org.springframework.util.ClassUtils.getAllInterfacesForClass(targetClass)) {
                try {
                    if (!"org.springframework.integration.gateway.RequestReplyExchanger".equals(iface.getName())) continue;
                    frameworkMethods.add(targetClass.getMethod("exchange", Message.class));
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)(targetObject.getClass() + ": Ambiguous fallback methods; using RequestReplyExchanger.exchange()"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (frameworkMethods.size() == 1) {
                HandlerMethod handlerMethod = new HandlerMethod((Method)frameworkMethods.get(0), this.canProcessMessageList);
                handlerMethods.put(CANDIDATE_METHODS, Collections.singletonMap(Object.class, handlerMethod));
                handlerMethods.put(CANDIDATE_MESSAGE_METHODS, candidateMessageMethods);
                return handlerMethods;
            }
        }
        try {
            Assert.state((!fallbackMethods.isEmpty() || !fallbackMessageMethods.isEmpty() ? 1 : 0) != 0, (String)("Target object of type [" + this.targetObject.getClass() + "] has no eligible methods for handling Messages."));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        Assert.isNull(ambiguousFallbackType.get(), (String)("Found ambiguous parameter type [" + ambiguousFallbackType + "] for method match: " + fallbackMethods.values()));
        Assert.isNull(ambiguousFallbackMessageGenericType.get(), (String)("Found ambiguous parameter type [" + ambiguousFallbackMessageGenericType + "] for method match: " + fallbackMethods.values()));
        handlerMethods.put(CANDIDATE_METHODS, fallbackMethods);
        handlerMethods.put(CANDIDATE_MESSAGE_METHODS, fallbackMessageMethods);
        return handlerMethods;
    }

    private Class<?> getTargetClass(Object targetObject) {
        Class superClass;
        Class targetClass = targetObject.getClass();
        if (AopUtils.isAopProxy((Object)targetObject)) {
            targetClass = AopUtils.getTargetClass((Object)targetObject);
            if (targetClass == targetObject.getClass()) {
                try {
                    Class[] interfaces = ((Advised)targetObject).getProxiedInterfaces();
                    if (interfaces != null && interfaces.length == 1) {
                        targetClass = interfaces[0];
                    }
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Exception trying to extract interface", (Throwable)e);
                    }
                }
            }
        } else if (org.springframework.util.ClassUtils.isCglibProxyClass(targetClass) && !Object.class.equals(superClass = targetObject.getClass().getSuperclass())) {
            targetClass = superClass;
        }
        return targetClass;
    }

    private HandlerMethod findHandlerMethodForParameters(ParametersWrapper parameters) {
        if (this.handlerMethod != null) {
            return this.handlerMethod;
        }
        Class<?> payloadType = parameters.getFirstParameterType();
        HandlerMethod closestMatch = this.findClosestMatch(payloadType);
        if (closestMatch != null) {
            return closestMatch;
        }
        if (Iterable.class.isAssignableFrom(payloadType) && this.handlerMethods.containsKey(Iterator.class)) {
            return this.handlerMethods.get(Iterator.class);
        }
        return this.handlerMethods.get(Void.class);
    }

    private HandlerMethod findClosestMatch(Class<?> payloadType) {
        for (Map map : this.handlerMethodsList) {
            Set<Class<?>> candidates = map.keySet();
            Class<?> match = null;
            if (!CollectionUtils.isEmpty(candidates)) {
                match = ClassUtils.findClosestMatch(payloadType, candidates, true);
            }
            if (match == null) continue;
            return (HandlerMethod)map.get(match);
        }
        return null;
    }

    private static boolean isMethodDefinedOnObjectClass(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            return true;
        }
        if (ReflectionUtils.isEqualsMethod((Method)method) || ReflectionUtils.isHashCodeMethod((Method)method) || ReflectionUtils.isToStringMethod((Method)method) || AopUtils.isFinalizeMethod((Method)method)) {
            return true;
        }
        return method.getName().equals("clone") && method.getParameterTypes().length == 0;
    }

    private static class IneligibleMethodException
    extends RuntimeException {
        private IneligibleMethodException(String message) {
            super(message);
        }
    }

    public class ParametersWrapper {
        private final Object payload;
        private final Collection<Message<?>> messages;
        private final Map<String, ?> headers;
        private final Message<?> message;

        public ParametersWrapper(Message<?> message) {
            this.message = message;
            this.payload = message.getPayload();
            this.headers = message.getHeaders();
            this.messages = null;
        }

        public ParametersWrapper(Collection<Message<?>> messages, Map<String, ?> headers) {
            this.payload = null;
            this.messages = messages;
            this.headers = headers;
            this.message = null;
        }

        public Object getPayload() {
            Assert.state((this.payload != null ? 1 : 0) != 0, (String)"Invalid method parameter for payload: was expecting collection.");
            return this.payload;
        }

        public Collection<Message<?>> getMessages() {
            Assert.state((this.messages != null ? 1 : 0) != 0, (String)"Invalid method parameter for messages: was expecting a single payload.");
            return this.messages;
        }

        public Map<String, ?> getHeaders() {
            return this.headers;
        }

        public Message<?> getMessage() {
            return this.message;
        }

        public Class<?> getFirstParameterType() {
            if (this.payload != null) {
                return this.payload.getClass();
            }
            return this.messages.getClass();
        }
    }

    private static class HandlerMethod {
        private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
        private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new LocalVariableTableParameterNameDiscoverer();
        private static final TypeDescriptor messageTypeDescriptor = TypeDescriptor.valueOf(Message.class);
        private static final TypeDescriptor messageListTypeDescriptor = new TypeDescriptor(ReflectionUtils.findField(HandlerMethod.class, (String)"dummyMessages"));
        private static final TypeDescriptor messageArrayTypeDescriptor = TypeDescriptor.valueOf(Message[].class);
        private static final Collection<Message<?>> dummyMessages = Collections.emptyList();
        private final Method method;
        private final Expression expression;
        private final boolean canProcessMessageList;
        private volatile TypeDescriptor targetParameterTypeDescriptor;
        private volatile Class<?> targetParameterType = Void.class;
        private volatile boolean messageMethod;

        HandlerMethod(Method method, boolean canProcessMessageList) {
            this.method = method;
            this.canProcessMessageList = canProcessMessageList;
            this.expression = this.generateExpression(method);
        }

        Expression getExpression() {
            return this.expression;
        }

        Class<?> getTargetParameterType() {
            return this.targetParameterType;
        }

        private boolean isMessageMethod() {
            return this.messageMethod;
        }

        public String toString() {
            return this.method.toString();
        }

        private Expression generateExpression(Method method) {
            StringBuilder sb = new StringBuilder("#target." + method.getName() + "(");
            Class<?>[] parameterTypes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            boolean hasUnqualifiedMapParameter = false;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                MethodParameter methodParameter = new MethodParameter(method, i);
                TypeDescriptor parameterTypeDescriptor = new TypeDescriptor(methodParameter);
                Class parameterType = parameterTypeDescriptor.getObjectType();
                Annotation mappingAnnotation = this.findMappingAnnotation(parameterAnnotations[i]);
                if (mappingAnnotation != null) {
                    String qualifierExpression;
                    Class<? extends Annotation> annotationType = mappingAnnotation.annotationType();
                    if (annotationType.equals(Payload.class)) {
                        sb.append("payload");
                        qualifierExpression = ((Payload)mappingAnnotation).value();
                        if (StringUtils.hasText((String)qualifierExpression)) {
                            sb.append("." + qualifierExpression);
                        }
                        if (!StringUtils.hasText((String)qualifierExpression)) {
                            this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                        }
                    }
                    if (annotationType.equals(Payloads.class)) {
                        sb.append("messages.![payload");
                        qualifierExpression = ((Payloads)mappingAnnotation).value();
                        if (StringUtils.hasText((String)qualifierExpression)) {
                            sb.append("." + qualifierExpression);
                        }
                        sb.append("]");
                        if (StringUtils.hasText((String)qualifierExpression)) continue;
                        this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                        continue;
                    }
                    if (annotationType.equals(Headers.class)) {
                        Assert.isTrue((boolean)Map.class.isAssignableFrom(parameterType), (String)"The @Headers annotation can only be applied to a Map-typed parameter.");
                        sb.append("headers");
                        continue;
                    }
                    if (!annotationType.equals(Header.class)) continue;
                    Header headerAnnotation = (Header)mappingAnnotation;
                    sb.append(this.determineHeaderExpression(headerAnnotation, methodParameter));
                    continue;
                }
                if (parameterTypeDescriptor.isAssignableTo(messageTypeDescriptor)) {
                    this.messageMethod = true;
                    sb.append("message");
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (parameterTypeDescriptor.isAssignableTo(messageListTypeDescriptor) || parameterTypeDescriptor.isAssignableTo(messageArrayTypeDescriptor)) {
                    sb.append("messages");
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (Collection.class.isAssignableFrom(parameterType) || parameterType.isArray()) {
                    if (this.canProcessMessageList) {
                        sb.append("messages.![payload]");
                    } else {
                        sb.append("payload");
                    }
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (Iterator.class.isAssignableFrom(parameterType)) {
                    if (this.canProcessMessageList) {
                        Type type = method.getGenericParameterTypes()[i];
                        Type parameterizedType = null;
                        if (type instanceof ParameterizedType && (parameterizedType = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof ParameterizedType) {
                            parameterizedType = ((ParameterizedType)parameterizedType).getRawType();
                        }
                        if (parameterizedType != null && Message.class.isAssignableFrom((Class)parameterizedType)) {
                            sb.append("messages.iterator()");
                        } else {
                            sb.append("messages.![payload].iterator()");
                        }
                    } else {
                        sb.append("payload.iterator()");
                    }
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (Map.class.isAssignableFrom(parameterType)) {
                    if (Properties.class.isAssignableFrom(parameterType)) {
                        sb.append("payload instanceof T(java.util.Map) or (payload instanceof T(String) and payload.contains('=')) ? payload : headers");
                    } else {
                        sb.append("(payload instanceof T(java.util.Map) ? payload : headers)");
                    }
                    Assert.isTrue((!hasUnqualifiedMapParameter ? 1 : 0) != 0, (String)"Found more than one Map typed parameter without any qualification. Consider using @Payload or @Headers on at least one of the parameters.");
                    hasUnqualifiedMapParameter = true;
                    continue;
                }
                sb.append("payload");
                this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
            }
            if (hasUnqualifiedMapParameter && this.targetParameterType != null && Map.class.isAssignableFrom(this.targetParameterType)) {
                throw new IllegalArgumentException("Unable to determine payload matching parameter due to ambiguous Map typed parameters. Consider adding the @Payload and or @Headers annotations as appropriate.");
            }
            sb.append(")");
            if (this.targetParameterTypeDescriptor == null) {
                this.targetParameterTypeDescriptor = TypeDescriptor.valueOf(Void.class);
            }
            return EXPRESSION_PARSER.parseExpression(sb.toString());
        }

        private Annotation findMappingAnnotation(Annotation[] annotations) {
            if (annotations == null || annotations.length == 0) {
                return null;
            }
            Annotation match = null;
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> type = annotation.annotationType();
                if (!type.equals(Payload.class) && !type.equals(Payloads.class) && !type.equals(Header.class) && !type.equals(Headers.class)) continue;
                if (match != null) {
                    throw new MessagingException("At most one parameter annotation can be provided for message mapping, but found two: [" + match.annotationType().getName() + "] and [" + annotation.annotationType().getName() + "]");
                }
                match = annotation;
            }
            return match;
        }

        private String determineHeaderExpression(Header headerAnnotation, MethodParameter methodParameter) {
            methodParameter.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
            String headerName = null;
            String relativeExpression = "";
            String valueAttribute = headerAnnotation.value();
            if (!StringUtils.hasText((String)valueAttribute)) {
                headerName = methodParameter.getParameterName();
            } else if (valueAttribute.indexOf(46) != -1) {
                String[] tokens = valueAttribute.split("\\.", 2);
                headerName = tokens[0];
                if (StringUtils.hasText((String)tokens[1])) {
                    relativeExpression = "." + tokens[1];
                }
            } else {
                headerName = valueAttribute;
            }
            Assert.notNull((Object)headerName, (String)"Cannot determine header name. Possible reasons: -debug is disabled or header name is not explicitly provided via @Header annotation.");
            String headerRetrievalExpression = "headers['" + headerName + "']";
            String fullHeaderExpression = headerRetrievalExpression + relativeExpression;
            String fallbackExpression = headerAnnotation.required() ? "T(org.springframework.util.Assert).isTrue(false, 'required header not available:  " + headerName + "')" : "null";
            return headerRetrievalExpression + " != null ? " + fullHeaderExpression + " : " + fallbackExpression;
        }

        private synchronized void setExclusiveTargetParameterType(TypeDescriptor targetParameterType, MethodParameter methodParameter) {
            if (this.targetParameterTypeDescriptor != null) {
                throw new IneligibleMethodException("Found more than one parameter type candidate: [" + this.targetParameterTypeDescriptor + "] and [" + targetParameterType + "]");
            }
            this.targetParameterTypeDescriptor = targetParameterType;
            if (Message.class.isAssignableFrom(targetParameterType.getObjectType())) {
                methodParameter.increaseNestingLevel();
                this.targetParameterType = methodParameter.getNestedParameterType();
                methodParameter.decreaseNestingLevel();
            } else {
                this.targetParameterType = targetParameterType.getObjectType();
            }
        }
    }
}

