/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.binding.mapping.MappingResult;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.MappingResultsCriteria;
import org.springframework.binding.message.Message;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageCriteria;
import org.springframework.binding.message.Severity;
import org.springframework.validation.AbstractErrors;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class MessageContextErrors
extends AbstractErrors {
    private MessageContext messageContext;
    private String objectName;
    private Object boundObject;
    private ExpressionParser expressionParser;
    private MappingResults mappingResults;
    private static MessageCriteria GLOBAL_ERROR = new MessageCriteria(){

        public boolean test(Message message) {
            return message.getSource() == null && message.getSeverity().equals((Object)Severity.ERROR);
        }
    };
    private static MessageCriteria FIELD_ERROR = new MessageCriteria(){

        public boolean test(Message message) {
            return message.getSource() != null && message.getSeverity().equals((Object)Severity.ERROR);
        }
    };

    public MessageContextErrors(MessageContext messageContext, String objectName, Object boundObject, ExpressionParser expressionParser, MappingResults mappingResults) {
        this.messageContext = messageContext;
        this.objectName = objectName;
        this.boundObject = boundObject;
        this.expressionParser = expressionParser;
        this.mappingResults = mappingResults;
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        this.messageContext.addMessage(new MessageBuilder().error().code(errorCode).args(errorArgs).defaultText(defaultMessage).build());
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        this.messageContext.addMessage(new MessageBuilder().error().source(field).code(errorCode).args(errorArgs).defaultText(defaultMessage).build());
    }

    public void addAllErrors(Errors errors) {
        Iterator it = errors.getAllErrors().iterator();
        while (it.hasNext()) {
            ObjectError error = (ObjectError)it.next();
            if (error instanceof FieldError) {
                FieldError fieldError = (FieldError)error;
                this.rejectValue(fieldError.getField(), error.getCode(), error.getArguments(), error.getDefaultMessage());
                continue;
            }
            this.reject(error.getCode(), error.getArguments(), error.getDefaultMessage());
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public List getGlobalErrors() {
        Message[] messages = this.messageContext.getMessagesByCriteria(GLOBAL_ERROR);
        if (messages.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ObjectError> errors = new ArrayList<ObjectError>(messages.length);
        int i = 0;
        while (i < messages.length) {
            Message message = messages[i];
            errors.add(new ObjectError(this.objectName, message.getText()));
            ++i;
        }
        return errors;
    }

    public List getFieldErrors() {
        Message[] messages = this.messageContext.getMessagesByCriteria(FIELD_ERROR);
        if (messages.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FieldError> errors = new ArrayList<FieldError>(messages.length);
        int i = 0;
        while (i < messages.length) {
            Message message = messages[i];
            errors.add(new FieldError(this.objectName, (String)message.getSource(), message.getText()));
            ++i;
        }
        return errors;
    }

    public Object getFieldValue(String field) {
        List results;
        if (this.mappingResults != null && !(results = this.mappingResults.getResults(new PropertyErrorMappingResult(field))).isEmpty()) {
            MappingResult fieldError = (MappingResult)results.get(0);
            return fieldError.getOriginalValue();
        }
        return this.parseFieldExpression(field).getValue(this.boundObject);
    }

    private Expression parseFieldExpression(String field) {
        return this.expressionParser.parseExpression(field, new FluentParserContext().evaluate(this.boundObject.getClass()));
    }

    private static class PropertyErrorMappingResult
    implements MappingResultsCriteria {
        private String property;

        public PropertyErrorMappingResult(String property) {
            this.property = property;
        }

        public boolean test(MappingResult result) {
            return result.isError() && this.property.equals(result.getMapping().getTargetExpression().getExpressionString());
        }
    }
}

