/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.element;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.ElementNameProcessorMatcher;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.IProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.processor.ProcessorResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementProcessor
extends AbstractProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IElementNameProcessorMatcher matcher;

    protected AbstractElementProcessor(String elementName) {
        this(new ElementNameProcessorMatcher(elementName));
    }

    protected AbstractElementProcessor(IElementNameProcessorMatcher matcher) {
        this.matcher = matcher;
    }

    public IProcessorMatcher<? extends Element> getMatcher() {
        return this.matcher;
    }

    @Override
    protected final ProcessorResult doProcess(Arguments arguments, ProcessorMatchingContext processorMatchingContext, Node node) {
        if (this.logger.isTraceEnabled()) {
            String elementName = ((Element)node).getNormalizedName();
            this.logger.trace("[THYMELEAF][{}][{}] Processing element \"{}\"", new Object[]{TemplateEngine.threadIndex(), arguments.getTemplateName(), elementName});
        }
        return this.processElement(arguments, (Element)node);
    }

    protected abstract ProcessorResult processElement(Arguments var1, Element var2);
}

