/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.doctype.resolution.IDocTypeResolutionEntry;
import org.thymeleaf.doctype.translation.IDocTypeTranslation;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.NotInitializedException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.processor.IProcessorMatcher;
import org.thymeleaf.processor.ProcessorAndContext;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DialectConfiguration {
    private final String prefix;
    private final IDialect dialect;
    private Set<IDocTypeTranslation> docTypeTranslations;
    private Set<IDocTypeResolutionEntry> docTypeResolutionEntries;
    private Set<IProcessor> processors;
    private Map<String, Set<ProcessorAndContext>> specificProcessorsByElementName;
    private Map<String, Set<ProcessorAndContext>> specificProcessorsByAttributeName;
    private Map<Class<? extends Node>, Set<ProcessorAndContext>> nonSpecificProcessorsByNodeClass;
    private Map<String, Object> executionAttributes;
    private volatile boolean initialized;

    DialectConfiguration(String prefix, IDialect dialect) {
        Validate.notNull(dialect, "Dialect cannot be null");
        this.prefix = prefix;
        this.dialect = dialect;
        this.initialized = false;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void checkInitialized() {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Configuration has not been initialized");
        }
    }

    public synchronized void initialize() {
        if (!this.isInitialized()) {
            this.processors = new LinkedHashSet<IProcessor>(this.dialect.getProcessors());
            this.processors = Collections.unmodifiableSet(this.processors);
            Validate.containsNoNulls(this.processors, "Processor set can contain no nulls (dialect: " + this.dialect.getClass().getName() + ")");
            ProcessorMatchingContext context = new ProcessorMatchingContext(this.dialect, this.prefix);
            HashMap<String, HashSet<ProcessorAndContext>> newSpecificProcessorsByElementName = new HashMap<String, HashSet<ProcessorAndContext>>(20);
            HashMap<String, HashSet<ProcessorAndContext>> newSpecificProcessorsByAttributeName = new HashMap<String, HashSet<ProcessorAndContext>>(20);
            HashMap<Class<? extends Node>, HashSet<ProcessorAndContext>> newNonSpecificProcessorsByNodeClass = new HashMap<Class<? extends Node>, HashSet<ProcessorAndContext>>(20);
            for (IProcessor processor : this.processors) {
                IProcessorMatcher<? extends Node> processorMatcher = processor.getMatcher();
                if (processorMatcher == null) {
                    throw new ConfigurationException("Processor of class \"" + processor.getClass().getName() + "\" returned null processor matcher.");
                }
                if (processorMatcher instanceof IElementNameProcessorMatcher) {
                    String[] elementNames = ((IElementNameProcessorMatcher)processorMatcher).getElementNames(context);
                    if (elementNames == null) {
                        throw new ConfigurationException("Processor of class \"" + processor.getClass().getName() + "\" returned a null element name as a part of its applicability specifications.");
                    }
                    for (String elementName : elementNames) {
                        HashSet<ProcessorAndContext> processorsForElementName = (HashSet<ProcessorAndContext>)newSpecificProcessorsByElementName.get(elementName);
                        if (processorsForElementName == null) {
                            processorsForElementName = new HashSet<ProcessorAndContext>(20);
                            newSpecificProcessorsByElementName.put(elementName, processorsForElementName);
                        }
                        processorsForElementName.add(new ProcessorAndContext(processor, context));
                    }
                }
                if (processorMatcher instanceof IAttributeNameProcessorMatcher) {
                    String[] attributeNames = ((IAttributeNameProcessorMatcher)processorMatcher).getAttributeNames(context);
                    if (attributeNames == null) {
                        throw new ConfigurationException("Processor of class \"" + processor.getClass().getName() + "\" returned a null attribute name as a part of its applicability specifications.");
                    }
                    for (String attributeName : attributeNames) {
                        HashSet<ProcessorAndContext> processorsForAttributeName = (HashSet<ProcessorAndContext>)newSpecificProcessorsByAttributeName.get(attributeName);
                        if (processorsForAttributeName == null) {
                            processorsForAttributeName = new HashSet<ProcessorAndContext>(20);
                            newSpecificProcessorsByAttributeName.put(attributeName, processorsForAttributeName);
                        }
                        processorsForAttributeName.add(new ProcessorAndContext(processor, context));
                    }
                }
                if (processorMatcher instanceof IElementNameProcessorMatcher || processorMatcher instanceof IAttributeNameProcessorMatcher) continue;
                Class<? extends Node> appliesTo = processorMatcher.appliesTo();
                HashSet<ProcessorAndContext> processorsForNodeClass = (HashSet<ProcessorAndContext>)newNonSpecificProcessorsByNodeClass.get(appliesTo);
                if (processorsForNodeClass == null) {
                    processorsForNodeClass = new HashSet<ProcessorAndContext>(20);
                    newNonSpecificProcessorsByNodeClass.put(appliesTo, processorsForNodeClass);
                }
                processorsForNodeClass.add(new ProcessorAndContext(processor, context));
            }
            this.specificProcessorsByElementName = Collections.unmodifiableMap(newSpecificProcessorsByElementName);
            this.specificProcessorsByAttributeName = Collections.unmodifiableMap(newSpecificProcessorsByAttributeName);
            this.nonSpecificProcessorsByNodeClass = Collections.unmodifiableMap(newNonSpecificProcessorsByNodeClass);
            this.executionAttributes = new HashMap<String, Object>(5, 1.0f);
            this.executionAttributes.putAll(this.dialect.getExecutionAttributes());
            this.docTypeTranslations = Collections.unmodifiableSet(new LinkedHashSet<IDocTypeTranslation>(this.dialect.getDocTypeTranslations()));
            Validate.containsNoNulls(this.docTypeTranslations, "Document Type translations can contain no nulls");
            this.validateDocTypeTranslations();
            this.docTypeResolutionEntries = Collections.unmodifiableSet(new LinkedHashSet<IDocTypeResolutionEntry>(this.dialect.getDocTypeResolutionEntries()));
            Validate.containsNoNulls(this.docTypeResolutionEntries, "Document Type resolution entries can contain no nulls");
            this.validateDocTypeResolutionEntries();
            this.initialized = true;
        }
    }

    public synchronized IDialect getDialect() {
        return this.dialect;
    }

    public String getPrefix() {
        return this.prefix;
    }

    Set<IProcessor> getProcessors() {
        return this.processors;
    }

    Map<String, Set<ProcessorAndContext>> unsafeGetSpecificProcessorsByAttributeName() {
        return this.specificProcessorsByAttributeName;
    }

    Map<String, Set<ProcessorAndContext>> unsafeGetSpecificProcessorsByElementName() {
        return this.specificProcessorsByElementName;
    }

    Map<Class<? extends Node>, Set<ProcessorAndContext>> unsafeGetNonSpecificProcessorsByNodeClass() {
        return this.nonSpecificProcessorsByNodeClass;
    }

    Map<String, Object> getExecutionAttributes() {
        return this.executionAttributes;
    }

    private void validateDocTypeTranslations() {
        for (IDocTypeTranslation translation : this.docTypeTranslations) {
            if (translation.getSourcePublicID() == null) {
                throw new ConfigurationException("Translation specifies a null Source PUBLICID. Document Type identifiers should never be null. Use \"NONE\" if you want to specify a non-existent identifier");
            }
            if (translation.getSourceSystemID() == null) {
                throw new ConfigurationException("Translation specifies a null Source SYSTEMID. Document Type identifiers should never be null. Use \"NONE\" if you want to specify a non-existent identifier");
            }
            if (translation.getTargetPublicID() == null) {
                throw new ConfigurationException("Translation specifies a null Target PUBLICID. Document Type identifiers should never be null. Use \"NONE\" if you want to specify a non-existent identifier");
            }
            if (translation.getTargetSystemID() != null) continue;
            throw new ConfigurationException("Translation specifies a null Target SYSTEMID. Document Type identifiers should never be null. Use \"NONE\" if you want to specify a non-existent identifier");
        }
    }

    private void validateDocTypeResolutionEntries() {
        LinkedHashSet<IDocTypeResolutionEntry> entriesAlreadyValidated = new LinkedHashSet<IDocTypeResolutionEntry>(10, 1.0f);
        for (IDocTypeResolutionEntry entry : this.docTypeResolutionEntries) {
            for (IDocTypeResolutionEntry validatedEntry : entriesAlreadyValidated) {
                if ((!validatedEntry.getPublicID().matches(entry.getPublicID()) || !validatedEntry.getSystemID().matches(entry.getSystemID())) && (!entry.getPublicID().matches(validatedEntry.getPublicID()) || !entry.getSystemID().matches(validatedEntry.getSystemID()))) continue;
                throw new ConfigurationException("Dialect specifies at least a couple of Document type resolution entries that would match each other, which would render resolution unpredictable");
            }
            entriesAlreadyValidated.add(entry);
        }
    }
}

