/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.attr;

import java.util.ArrayList;
import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.util.Validate;

@Deprecated
public abstract class AbstractRemovalAttrProcessor
extends AbstractAttrProcessor {
    private final String removeAll = this.getRemoveAllAttrValue();
    private final String removeAllButFirst = this.getRemoveAllButFirstAttrValue();
    private final String removeElement = this.getRemoveElementAttrValue();
    private final String removeBody = this.getRemoveBodyAttrValue();

    protected AbstractRemovalAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
        this.validateValues();
    }

    protected AbstractRemovalAttrProcessor(String attributeName) {
        super(attributeName);
        this.validateValues();
    }

    private void validateValues() {
        Validate.notEmpty(this.removeAll, "Attribute value for \"remove all\" cannot be null or empty in processor " + this.getClass().getName());
        Validate.notEmpty(this.removeAllButFirst, "Attribute value for \"remove all but first\" cannot be null or empty in processor " + this.getClass().getName());
        Validate.notEmpty(this.removeElement, "Attribute value for \"remove element\" cannot be null or empty in processor " + this.getClass().getName());
        Validate.notEmpty(this.removeBody, "Attribute value for \"remove body\" cannot be null or empty in processor " + this.getClass().getName());
        Validate.isTrue(!this.removeAll.equals(this.removeElement), "All three attribute values for processor " + this.getClass().getName() + " must be different");
        Validate.isTrue(!this.removeAll.equals(this.removeBody), "All three attribute values for processor " + this.getClass().getName() + " must be different");
        Validate.isTrue(!this.removeElement.equals(this.removeBody), "All three attribute values for processor " + this.getClass().getName() + " must be different");
    }

    public final ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        if (attributeValue != null) {
            String value = attributeValue.trim();
            if (this.removeAll.equals(value)) {
                element.getParent().removeChild(element);
                return ProcessorResult.OK;
            }
            if (this.removeAllButFirst.equals(value)) {
                List<Node> children = element.getChildren();
                ArrayList<Node> newChildren = new ArrayList<Node>(children.size());
                boolean childElementFound = false;
                for (Node child : children) {
                    if (child instanceof Element) {
                        if (childElementFound) continue;
                        newChildren.add(child);
                        childElementFound = true;
                        continue;
                    }
                    newChildren.add(child);
                }
                element.setChildren(newChildren);
                element.removeAttribute(attributeName);
                return ProcessorResult.OK;
            }
            if (this.removeElement.equals(value)) {
                element.getParent().extractChild(element);
                return ProcessorResult.OK;
            }
            if (this.removeBody.equals(value)) {
                element.clearChildren();
                element.removeAttribute(attributeName);
                return ProcessorResult.OK;
            }
        }
        throw new TemplateProcessingException("Unrecognized value for \"" + attributeName + "\": only \"" + this.removeElement + "\", \"" + this.removeBody + "\" and \"" + this.removeAll + "\" are allowed.");
    }

    protected abstract String getRemoveAllAttrValue();

    protected abstract String getRemoveAllButFirstAttrValue();

    protected abstract String getRemoveBodyAttrValue();

    protected abstract String getRemoveElementAttrValue();
}

