/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.expression;

import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.thymeleaf.spring3.context.Beans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeansPropertyAccessor
extends ReflectivePropertyAccessor {
    private static final Class<?>[] TARGET_CLASSES = new Class[]{Beans.class};
    public static final BeansPropertyAccessor INSTANCE = new BeansPropertyAccessor();

    BeansPropertyAccessor() {
    }

    public Class<?>[] getSpecificTargetClasses() {
        return TARGET_CLASSES;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        if (target == null) {
            return false;
        }
        if (!(target instanceof Beans)) {
            throw new AccessException("Cannot read target of class " + target.getClass().getName());
        }
        return ((Beans)target).containsKey(name);
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        if (target == null) {
            throw new AccessException("Cannot read property of null target");
        }
        if (!(target instanceof Beans)) {
            throw new AccessException("Cannot read target of class " + target.getClass().getName());
        }
        return new TypedValue(((Beans)target).get(name));
    }
}

