/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.webjars.WebJarExtractor;

public class FileSystemCache
implements WebJarExtractor.Cache {
    private final File cache;
    private Map<String, WebJarExtractor.Cacheable> onFile;
    private Map<String, WebJarExtractor.Cacheable> touched;
    private boolean dirty;

    public FileSystemCache(File cache) throws IOException {
        this.cache = cache;
        this.reset();
    }

    @Override
    public boolean isUpToDate(String key, WebJarExtractor.Cacheable cacheable) {
        WebJarExtractor.Cacheable t = this.touched.get(key);
        if (t != null) {
            return cacheable.equals(t);
        }
        WebJarExtractor.Cacheable cached = this.onFile.get(key);
        if (cached != null) {
            this.touched.put(key, cached);
        }
        return cacheable.equals(cached);
    }

    @Override
    public void put(String key, WebJarExtractor.Cacheable cacheable) {
        this.touched.put(key, cacheable);
        this.dirty = true;
    }

    public void save() throws IOException {
        if (this.dirty || this.onFile.size() != this.touched.size()) {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.cache), StandardCharsets.UTF_8);){
                for (Map.Entry<String, WebJarExtractor.Cacheable> item : this.touched.entrySet()) {
                    writer.write(item.getKey() + ":" + item.getValue().getLastModified() + ":" + item.getValue().getPath() + "\n");
                }
                ((Writer)writer).flush();
            }
        }
        this.onFile = this.touched;
        this.touched = new HashMap<String, WebJarExtractor.Cacheable>();
        this.dirty = false;
    }

    public void reset() throws IOException {
        this.onFile = new HashMap<String, WebJarExtractor.Cacheable>();
        if (this.cache.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cache), StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    String[] splitted;
                    if (!line.isEmpty() && (splitted = line.split(":", 3)).length == 3) {
                        String key = splitted[0];
                        String lastModified = splitted[1];
                        String path = splitted[2];
                        try {
                            long lm = Long.parseLong(lastModified);
                            this.onFile.put(key, new WebJarExtractor.Cacheable(path, lm));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    line = reader.readLine();
                }
            }
        }
        this.touched = new HashMap<String, WebJarExtractor.Cacheable>();
        this.dirty = false;
    }

    public Set<File> getExistingUntouchedFiles(File baseDir) throws IOException {
        File file;
        HashSet<File> untouchedFiles = new HashSet<File>();
        for (String key : this.onFile.keySet()) {
            file = new File(baseDir, key);
            if (!file.exists()) continue;
            untouchedFiles.add(file.getCanonicalFile());
        }
        for (String key : this.touched.keySet()) {
            file = new File(baseDir, key);
            if (!file.exists()) continue;
            untouchedFiles.remove(file.getCanonicalFile());
        }
        return untouchedFiles;
    }
}

