/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.custom;

import com.alibaba.csp.sentinel.util.StringUtil;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class BlockClassRegistry {
    private static final Map<String, Method> FALLBACK_MAP = new ConcurrentHashMap<String, Method>();
    private static final Map<String, Method> BLOCK_HANDLER_MAP = new ConcurrentHashMap<String, Method>();
    private static final Map<String, Method> URL_CLEANER_MAP = new ConcurrentHashMap<String, Method>();

    BlockClassRegistry() {
    }

    static Method lookupFallback(Class<?> clazz, String name) {
        return FALLBACK_MAP.get(BlockClassRegistry.getKey(clazz, name));
    }

    static Method lookupBlockHandler(Class<?> clazz, String name) {
        return BLOCK_HANDLER_MAP.get(BlockClassRegistry.getKey(clazz, name));
    }

    static Method lookupUrlCleaner(Class<?> clazz, String name) {
        return URL_CLEANER_MAP.get(BlockClassRegistry.getKey(clazz, name));
    }

    static void updateFallbackFor(Class<?> clazz, String name, Method method) {
        if (clazz == null || StringUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("Bad argument");
        }
        FALLBACK_MAP.put(BlockClassRegistry.getKey(clazz, name), method);
    }

    static void updateBlockHandlerFor(Class<?> clazz, String name, Method method) {
        if (clazz == null || StringUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("Bad argument");
        }
        BLOCK_HANDLER_MAP.put(BlockClassRegistry.getKey(clazz, name), method);
    }

    static void updateUrlCleanerFor(Class<?> clazz, String name, Method method) {
        if (clazz == null || StringUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("Bad argument");
        }
        URL_CLEANER_MAP.put(BlockClassRegistry.getKey(clazz, name), method);
    }

    private static String getKey(Class<?> clazz, String name) {
        return String.format("%s:%s", clazz.getCanonicalName(), name);
    }
}

