/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.endpoint;

import com.alibaba.cloud.sentinel.SentinelProperties;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.heartbeat.HeartbeatSenderProvider;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.util.StringUtils;

public class SentinelHealthIndicator
extends AbstractHealthIndicator {
    private DefaultListableBeanFactory beanFactory;
    private SentinelProperties sentinelProperties;

    public SentinelHealthIndicator(DefaultListableBeanFactory beanFactory, SentinelProperties sentinelProperties) {
        this.beanFactory = beanFactory;
        this.sentinelProperties = sentinelProperties;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        HashMap<String, Serializable> detailMap = new HashMap<String, Serializable>();
        if (!this.sentinelProperties.isEnabled()) {
            detailMap.put("enabled", Boolean.valueOf(false));
            builder.up().withDetails(detailMap);
            return;
        }
        detailMap.put("enabled", Boolean.valueOf(true));
        boolean dashboardUp = true;
        String consoleServer = TransportConfig.getConsoleServer();
        if (StringUtils.isEmpty((Object)consoleServer)) {
            detailMap.put("dashboard", (Serializable)new Status(Status.UNKNOWN.getCode(), "dashboard isn't configured"));
        } else {
            HeartbeatSender heartbeatSender = HeartbeatSenderProvider.getHeartbeatSender();
            boolean result = heartbeatSender.sendHeartbeat();
            if (result) {
                detailMap.put("dashboard", (Serializable)Status.UP);
            } else {
                dashboardUp = false;
                detailMap.put("dashboard", (Serializable)new Status(Status.DOWN.getCode(), consoleServer + " can't be connected"));
            }
        }
        boolean dataSourceUp = true;
        HashMap<String, Status> dataSourceDetailMap = new HashMap<String, Status>();
        detailMap.put("dataSource", dataSourceDetailMap);
        Map dataSourceMap = this.beanFactory.getBeansOfType(AbstractDataSource.class);
        for (Map.Entry dataSourceMapEntry : dataSourceMap.entrySet()) {
            String dataSourceBeanName = (String)dataSourceMapEntry.getKey();
            AbstractDataSource dataSource = (AbstractDataSource)dataSourceMapEntry.getValue();
            try {
                dataSource.loadConfig();
                dataSourceDetailMap.put(dataSourceBeanName, Status.UP);
            }
            catch (Exception e) {
                dataSourceUp = false;
                dataSourceDetailMap.put(dataSourceBeanName, new Status(Status.DOWN.getCode(), e.getMessage()));
            }
        }
        if (dashboardUp && dataSourceUp) {
            builder.up().withDetails(detailMap);
        } else {
            builder.down().withDetails(detailMap);
        }
    }
}

