/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.command;

import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.List;

@CommandMapping(name="gateway/updateRules", desc="Update gateway rules")
public class UpdateGatewayRuleCommandHandler
implements CommandHandler<String> {
    private static final String SUCCESS_MSG = "success";

    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank((String)data)) {
            return CommandResponse.ofFailure((Throwable)new IllegalArgumentException("Bad data"));
        }
        try {
            data = URLDecoder.decode(data, "utf-8");
        }
        catch (Exception e) {
            RecordLog.info((String)"Decode gateway rule data error", (Throwable)e);
            return CommandResponse.ofFailure((Throwable)e, (Object)"decode gateway rule data error");
        }
        RecordLog.info((String)String.format("[API Server] Receiving rule change (type: gateway rule): %s", data), (Object[])new Object[0]);
        String result = SUCCESS_MSG;
        List flowRules = JSONArray.parseArray((String)data, GatewayFlowRule.class);
        GatewayRuleManager.loadRules(new HashSet<GatewayFlowRule>(flowRules));
        return CommandResponse.ofSuccess((Object)result);
    }
}

