/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLDataTypeImpl
extends SQLObjectImpl
implements SQLDataType {
    protected String name;
    protected final List<SQLExpr> arguments = new ArrayList<SQLExpr>();
    private Boolean withTimeZone;
    private boolean withLocalTimeZone = false;

    public SQLDataTypeImpl() {
    }

    public SQLDataTypeImpl(String name) {
        this.name = name;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.arguments);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<SQLExpr> getArguments() {
        return this.arguments;
    }

    public void addArgument(SQLExpr argument) {
        if (argument != null) {
            argument.setParent(this);
        }
        this.arguments.add(argument);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLDataTypeImpl dataType = (SQLDataTypeImpl)o;
        if (this.name != null ? !this.name.equals(dataType.name) : dataType.name != null) {
            return false;
        }
        if (this.arguments != null ? !this.arguments.equals(dataType.arguments) : dataType.arguments != null) {
            return false;
        }
        return this.withTimeZone != null ? this.withTimeZone.equals(dataType.withTimeZone) : dataType.withTimeZone == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        result = 31 * result + (this.withTimeZone != null ? this.withTimeZone.hashCode() : 0);
        return result;
    }

    @Override
    public Boolean getWithTimeZone() {
        return this.withTimeZone;
    }

    @Override
    public void setWithTimeZone(Boolean withTimeZone) {
        this.withTimeZone = withTimeZone;
    }

    @Override
    public boolean isWithLocalTimeZone() {
        return this.withLocalTimeZone;
    }

    public void setWithLocalTimeZone(boolean withLocalTimeZone) {
        this.withLocalTimeZone = withLocalTimeZone;
    }
}

