/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.lang.Consumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SQLCreateTableStatement
extends SQLStatementImpl
implements SQLDDLStatement {
    protected boolean ifNotExiists = false;
    protected Type type;
    protected SQLExprTableSource tableSource;
    protected List<SQLTableElement> tableElementList = new ArrayList<SQLTableElement>();
    private SQLExprTableSource inherits;
    protected SQLSelect select;

    public SQLCreateTableStatement() {
    }

    public SQLCreateTableStatement(String dbType) {
        super(dbType);
    }

    public SQLName getName() {
        if (this.tableSource == null) {
            return null;
        }
        return (SQLName)this.tableSource.getExpr();
    }

    public void setName(SQLName name) {
        this.setTableSource(new SQLExprTableSource(name));
    }

    public SQLExprTableSource getTableSource() {
        return this.tableSource;
    }

    public void setTableSource(SQLExprTableSource tableSource) {
        if (tableSource != null) {
            tableSource.setParent(this);
        }
        this.tableSource = tableSource;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<SQLTableElement> getTableElementList() {
        return this.tableElementList;
    }

    public boolean isIfNotExiists() {
        return this.ifNotExiists;
    }

    public void setIfNotExiists(boolean ifNotExiists) {
        this.ifNotExiists = ifNotExiists;
    }

    public SQLExprTableSource getInherits() {
        return this.inherits;
    }

    public void setInherits(SQLExprTableSource inherits) {
        if (inherits != null) {
            inherits.setParent(this);
        }
        this.inherits = inherits;
    }

    public SQLSelect getSelect() {
        return this.select;
    }

    public void setSelect(SQLSelect select) {
        this.select = select;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tableSource);
            this.acceptChild(visitor, this.tableElementList);
            this.acceptChild(visitor, this.inherits);
            this.acceptChild(visitor, this.select);
        }
        visitor.endVisit(this);
    }

    public void addBodyBeforeComment(List<String> comments) {
        List attrComments;
        if (this.attributes == null) {
            this.attributes = new HashMap(1);
        }
        if ((attrComments = (List)this.attributes.get("format.body_before_comment")) == null) {
            this.attributes.put("format.body_before_comment", comments);
        } else {
            attrComments.addAll(comments);
        }
    }

    public List<String> getBodyBeforeCommentsDirect() {
        if (this.attributes == null) {
            return null;
        }
        return (List)this.attributes.get("format.body_before_comment");
    }

    public boolean hasBodyBeforeComment() {
        List<String> comments = this.getBodyBeforeCommentsDirect();
        if (comments == null) {
            return false;
        }
        return !comments.isEmpty();
    }

    public String computeName() {
        if (this.tableSource == null) {
            return null;
        }
        SQLExpr expr = this.tableSource.getExpr();
        if (expr instanceof SQLName) {
            String name = ((SQLName)expr).getSimpleName();
            return SQLUtils.normalize(name);
        }
        return null;
    }

    public SQLColumnDefinition findColumn(String columName) {
        for (SQLTableElement element : this.tableElementList) {
            SQLColumnDefinition column;
            String name;
            if (!(element instanceof SQLColumnDefinition) || !columName.equalsIgnoreCase(name = (column = (SQLColumnDefinition)element).computeAlias())) continue;
            return column;
        }
        return null;
    }

    public SQLTableElement findIndex(String columnName) {
        for (SQLTableElement element : this.tableElementList) {
            List<SQLExpr> keyColumns = null;
            if (element instanceof SQLUniqueConstraint) {
                SQLUniqueConstraint unique = (SQLUniqueConstraint)((Object)element);
                keyColumns = unique.getColumns();
            } else if (element instanceof MySqlTableIndex) {
                keyColumns = ((MySqlTableIndex)element).getColumns();
            }
            if (keyColumns == null) continue;
            for (SQLExpr columnExpr : keyColumns) {
                if (!(columnExpr instanceof SQLIdentifierExpr)) continue;
                String keyColumName = ((SQLIdentifierExpr)columnExpr).getName();
                if (!(keyColumName = SQLUtils.normalize(keyColumName)).equalsIgnoreCase(columnName)) continue;
                return element;
            }
        }
        return null;
    }

    public void forEachColumn(Consumer<SQLColumnDefinition> columnConsumer) {
        if (columnConsumer == null) {
            return;
        }
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLColumnDefinition)) continue;
            columnConsumer.accept((SQLColumnDefinition)element);
        }
    }

    public SQLPrimaryKey findPrimaryKey() {
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLPrimaryKey)) continue;
            return (SQLPrimaryKey)element;
        }
        return null;
    }

    public static enum Type {
        GLOBAL_TEMPORARY,
        LOCAL_TEMPORARY;

    }
}

