/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata;

import com.alibaba.excel.annotation.ExcelColumnNum;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.CellRange;
import com.alibaba.excel.metadata.ExcelColumnProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelHeadProperty {
    private Class<? extends BaseRowModel> headClazz;
    private List<List<String>> head = new ArrayList<List<String>>();
    private List<ExcelColumnProperty> columnPropertyList = new ArrayList<ExcelColumnProperty>();
    private Map<Integer, ExcelColumnProperty> excelColumnPropertyMap1 = new HashMap<Integer, ExcelColumnProperty>();

    public ExcelHeadProperty(Class<? extends BaseRowModel> headClazz, List<List<String>> head) {
        this.headClazz = headClazz;
        this.head = head;
        this.initColumnProperties();
    }

    private void initColumnProperties() {
        if (this.headClazz != null) {
            Field[] fields = this.headClazz.getDeclaredFields();
            ArrayList<List<String>> headList = new ArrayList<List<String>>();
            for (Field f : fields) {
                this.initOneColumnProperty(f);
            }
            Collections.sort(this.columnPropertyList);
            if (this.head == null || this.head.size() == 0) {
                for (ExcelColumnProperty excelColumnProperty : this.columnPropertyList) {
                    headList.add(excelColumnProperty.getHead());
                }
                this.head = headList;
            }
        }
    }

    private void initOneColumnProperty(Field f) {
        ExcelProperty p = f.getAnnotation(ExcelProperty.class);
        ExcelColumnProperty excelHeadProperty = null;
        if (p != null) {
            excelHeadProperty = new ExcelColumnProperty();
            excelHeadProperty.setField(f);
            excelHeadProperty.setHead(Arrays.asList(p.value()));
            excelHeadProperty.setIndex(p.index());
            excelHeadProperty.setFormat(p.format());
            this.excelColumnPropertyMap1.put(p.index(), excelHeadProperty);
        } else {
            ExcelColumnNum columnNum = f.getAnnotation(ExcelColumnNum.class);
            if (columnNum != null) {
                excelHeadProperty = new ExcelColumnProperty();
                excelHeadProperty.setField(f);
                excelHeadProperty.setIndex(columnNum.value());
                excelHeadProperty.setFormat(columnNum.format());
                this.excelColumnPropertyMap1.put(columnNum.value(), excelHeadProperty);
            }
        }
        if (excelHeadProperty != null) {
            this.columnPropertyList.add(excelHeadProperty);
        }
    }

    public void appendOneRow(List<String> row) {
        for (int i = 0; i < row.size(); ++i) {
            List<Object> list;
            if (this.head.size() <= i) {
                list = new ArrayList();
                this.head.add(list);
            } else {
                list = this.head.get(0);
            }
            list.add(row.get(i));
        }
    }

    public ExcelColumnProperty getExcelColumnProperty(int columnNum) {
        ExcelColumnProperty excelColumnProperty = this.excelColumnPropertyMap1.get(columnNum);
        if (excelColumnProperty == null && this.head != null && this.head.size() > columnNum) {
            List<String> columnHead = this.head.get(columnNum);
            for (ExcelColumnProperty columnProperty : this.columnPropertyList) {
                if (!this.headEquals(columnHead, columnProperty.getHead())) continue;
                return columnProperty;
            }
        }
        return excelColumnProperty;
    }

    private boolean headEquals(List<String> columnHead, List<String> head) {
        boolean result = true;
        if (columnHead == null || head == null || columnHead.size() != head.size()) {
            return false;
        }
        for (int i = 0; i < head.size(); ++i) {
            if (head.get(i).equals(columnHead.get(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public Class getHeadClazz() {
        return this.headClazz;
    }

    public void setHeadClazz(Class headClazz) {
        this.headClazz = headClazz;
    }

    public List<List<String>> getHead() {
        return this.head;
    }

    public void setHead(List<List<String>> head) {
        this.head = head;
    }

    public List<ExcelColumnProperty> getColumnPropertyList() {
        return this.columnPropertyList;
    }

    public void setColumnPropertyList(List<ExcelColumnProperty> columnPropertyList) {
        this.columnPropertyList = columnPropertyList;
    }

    public List<CellRange> getCellRangeModels() {
        ArrayList<CellRange> rangs = new ArrayList<CellRange>();
        for (int i = 0; i < this.head.size(); ++i) {
            List<String> columnvalues = this.head.get(i);
            for (int j = 0; j < columnvalues.size(); ++j) {
                int lastRow = this.getLastRangRow(j, columnvalues.get(j), columnvalues);
                int lastColumn = this.getLastRangColumn(columnvalues.get(j), this.getHeadByRowNum(j), i);
                if (lastRow < 0 || lastColumn < 0 || lastRow <= j && lastColumn <= i) continue;
                rangs.add(new CellRange(j, lastRow, i, lastColumn));
            }
        }
        return rangs;
    }

    public List<String> getHeadByRowNum(int rowNum) {
        ArrayList<String> l = new ArrayList<String>(this.head.size());
        for (List<String> list : this.head) {
            if (list.size() > rowNum) {
                l.add(list.get(rowNum));
                continue;
            }
            l.add(list.get(list.size() - 1));
        }
        return l;
    }

    private int getLastRangColumn(String value, List<String> headByRowNum, int i) {
        if (headByRowNum.indexOf(value) < i) {
            return -1;
        }
        return headByRowNum.lastIndexOf(value);
    }

    private int getLastRangRow(int j, String value, List<String> columnvalue) {
        if (columnvalue.indexOf(value) < j) {
            return -1;
        }
        if (value != null && value.equals(columnvalue.get(columnvalue.size() - 1))) {
            return this.getRowNum() - 1;
        }
        return columnvalue.lastIndexOf(value);
    }

    public int getRowNum() {
        int headRowNum = 0;
        for (List<String> list : this.head) {
            if (list == null || list.size() <= 0 || list.size() <= headRowNum) continue;
            headRowNum = list.size();
        }
        return headRowNum;
    }
}

