/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.BroadcastOperations;
import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.SocketConfig;
import com.corundumstudio.socketio.SocketIOChannelInitializer;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIONamespace;
import com.corundumstudio.socketio.listener.ClientListeners;
import com.corundumstudio.socketio.listener.ConnectListener;
import com.corundumstudio.socketio.listener.DataListener;
import com.corundumstudio.socketio.listener.DisconnectListener;
import com.corundumstudio.socketio.listener.MultiTypeEventListener;
import com.corundumstudio.socketio.namespace.NamespacesHub;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketIOServer
implements ClientListeners {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Configuration configCopy;
    private final Configuration configuration;
    private final NamespacesHub namespacesHub;
    private final SocketIONamespace mainNamespace;
    private SocketIOChannelInitializer pipelineFactory = new SocketIOChannelInitializer();
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public SocketIOServer(Configuration configuration) {
        this.configuration = configuration;
        this.configCopy = new Configuration(configuration);
        this.namespacesHub = new NamespacesHub(this.configCopy);
        this.mainNamespace = this.addNamespace("");
    }

    public void setPipelineFactory(SocketIOChannelInitializer pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }

    public Collection<SocketIOClient> getAllClients() {
        return this.namespacesHub.get("").getAllClients();
    }

    public SocketIOClient getClient(UUID uuid) {
        return this.namespacesHub.get("").getClient(uuid);
    }

    public Collection<SocketIONamespace> getAllNamespaces() {
        return this.namespacesHub.getAllNamespaces();
    }

    public BroadcastOperations getBroadcastOperations() {
        return new BroadcastOperations(this.getAllClients(), this.configCopy.getStoreFactory());
    }

    public BroadcastOperations getRoomOperations(String room) {
        Iterable<SocketIOClient> clients = this.namespacesHub.getRoomClients(room);
        return new BroadcastOperations(clients, this.configCopy.getStoreFactory());
    }

    public void start() {
        this.initGroups();
        this.pipelineFactory.start(this.configCopy, this.namespacesHub);
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)this.pipelineFactory);
        this.applyConnectionOptions(b);
        InetSocketAddress addr = new InetSocketAddress(this.configCopy.getPort());
        if (this.configCopy.getHostname() != null) {
            addr = new InetSocketAddress(this.configCopy.getHostname(), this.configCopy.getPort());
        }
        b.bind((SocketAddress)addr).syncUninterruptibly();
        this.log.info("Session store / pubsub factory used: {}", (Object)this.configCopy.getStoreFactory());
        this.log.info("SocketIO server started at port: {}", (Object)this.configCopy.getPort());
    }

    protected void applyConnectionOptions(ServerBootstrap bootstrap) {
        SocketConfig config = this.configCopy.getSocketConfig();
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)config.isTcpNoDelay());
        if (config.getTcpSendBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)config.getTcpSendBufferSize());
        }
        if (config.getTcpReceiveBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)config.getTcpReceiveBufferSize());
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(config.getTcpReceiveBufferSize()));
        }
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)config.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_LINGER, (Object)config.getSoLinger());
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)config.isReuseAddress());
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)config.getAcceptBackLog());
    }

    protected void initGroups() {
        this.bossGroup = new NioEventLoopGroup(this.configCopy.getBossThreads());
        this.workerGroup = new NioEventLoopGroup(this.configCopy.getWorkerThreads());
    }

    public void stop() {
        this.bossGroup.shutdownGracefully().syncUninterruptibly();
        this.workerGroup.shutdownGracefully().syncUninterruptibly();
        this.pipelineFactory.stop();
        this.log.info("SocketIO server stopped");
    }

    public SocketIONamespace addNamespace(String name) {
        return this.namespacesHub.create(name);
    }

    public SocketIONamespace getNamespace(String name) {
        return this.namespacesHub.get(name);
    }

    public void removeNamespace(String name) {
        this.namespacesHub.remove(name);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void addMultiTypeEventListener(String eventName, MultiTypeEventListener listener, Class<?> ... eventClass) {
        this.mainNamespace.addMultiTypeEventListener(eventName, listener, eventClass);
    }

    @Override
    public <T> void addEventListener(String eventName, Class<T> eventClass, DataListener<T> listener) {
        this.mainNamespace.addEventListener(eventName, eventClass, listener);
    }

    @Override
    public <T> void addJsonObjectListener(Class<T> clazz, DataListener<T> listener) {
        this.mainNamespace.addJsonObjectListener(clazz, listener);
    }

    @Override
    public void addDisconnectListener(DisconnectListener listener) {
        this.mainNamespace.addDisconnectListener(listener);
    }

    @Override
    public void addConnectListener(ConnectListener listener) {
        this.mainNamespace.addConnectListener(listener);
    }

    @Override
    public void addMessageListener(DataListener<String> listener) {
        this.mainNamespace.addMessageListener(listener);
    }

    @Override
    public void addListeners(Object listeners) {
        this.mainNamespace.addListeners(listeners);
    }

    @Override
    public void addListeners(Object listeners, Class listenersClass) {
        this.mainNamespace.addListeners(listeners, listenersClass);
    }
}

