/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.Disconnectable;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.parser.PacketType;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import com.corundumstudio.socketio.transport.MainBaseClient;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatHandler
implements Disconnectable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CancelableScheduler scheduler;
    private final Configuration configuration;

    public HeartbeatHandler(Configuration configuration, CancelableScheduler scheduler) {
        this.configuration = configuration;
        this.scheduler = scheduler;
    }

    public void onHeartbeat(final MainBaseClient client) {
        if (!this.configuration.isHeartbeatsEnabled()) {
            return;
        }
        final SchedulerKey key = new SchedulerKey(SchedulerKey.Type.HEARBEAT_TIMEOUT, client.getSessionId());
        this.scheduler.cancel(key);
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                client.send(new Packet(PacketType.HEARTBEAT));
                HeartbeatHandler.this.scheduleClientHeartbeatCheck(client, key);
            }
        }, this.configuration.getHeartbeatInterval(), TimeUnit.SECONDS);
    }

    private void scheduleClientHeartbeatCheck(final MainBaseClient client, SchedulerKey key) {
        this.scheduler.cancel(key);
        this.scheduler.scheduleCallback(key, new Runnable(){

            @Override
            public void run() {
                client.disconnect();
                HeartbeatHandler.this.log.debug("Client with sessionId: {} disconnected due to heartbeat timeout", (Object)client.getSessionId());
            }
        }, this.configuration.getHeartbeatTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public void onDisconnect(MainBaseClient client) {
        this.scheduler.cancel(new SchedulerKey(SchedulerKey.Type.HEARBEAT_TIMEOUT, client.getSessionId()));
    }
}

